/*
 * Decompiled with CFR 0.152.
 */
package net.dzultra.jfa.punishments;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.dzultra.jfa.exceptions.JsoupConnectionException;
import net.dzultra.jfa.punishments.Punishment;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class LiteBansScraper {
    private static final String BASE = "https://www.mcfoxcraft.com/newbans/";

    public static List<Punishment> fetchPunishments(String uuid) {
        ArrayList<Punishment> records = new ArrayList<Punishment>();
        HashSet<CallSite> visitedPages = new HashSet<CallSite>();
        String nextPageUrl = "https://www.mcfoxcraft.com/newbans/history.php?uuid=" + uuid;
        while (nextPageUrl != null && visitedPages.add((CallSite)((Object)nextPageUrl))) {
            Document doc;
            try {
                doc = Jsoup.connect((String)nextPageUrl).userAgent("Mozilla/5.0").get();
                System.out.println("Sending Request to URL: " + nextPageUrl);
            }
            catch (IOException e) {
                throw new JsoupConnectionException(e, nextPageUrl);
            }
            Elements rows = doc.select("table tbody tr");
            for (Element row : rows) {
                Elements tds = row.select("td");
                if (tds.size() < 6) continue;
                Element typeLink = ((Element)tds.get(0)).selectFirst("a");
                String type = typeLink != null ? typeLink.text().trim() : ((Element)tds.get(0)).text().trim();
                String punishedPlayer = ((Element)tds.get(1)).selectFirst("span").text();
                String punishedUuid = LiteBansScraper.extractUuidFromAvatar((Element)tds.get(1));
                String moderator = ((Element)tds.get(2)).selectFirst("span").text();
                String moderatorUuid = LiteBansScraper.extractUuidFromAvatar((Element)tds.get(2));
                String reason = ((Element)tds.get(3)).text();
                String date = ((Element)tds.get(4)).text();
                String expires = ((Element)tds.get(5)).text();
                records.add(new Punishment(type, punishedPlayer, punishedUuid, moderator, moderatorUuid, reason, date, expires));
            }
            Element next = doc.selectFirst("a.litebans-pager-right.litebans-pager-active");
            if (next != null) {
                String newUrl = BASE + next.attr("href");
                if (newUrl.equals(nextPageUrl)) break;
                nextPageUrl = newUrl;
                continue;
            }
            nextPageUrl = null;
        }
        return records;
    }

    private static String extractUuidFromAvatar(Element td) {
        Element img = td.selectFirst("img");
        if (img == null) {
            return null;
        }
        String src = img.attr("src");
        int start = src.indexOf("avatar/");
        if (start == -1) {
            return null;
        }
        int end = src.indexOf(47, start += 7);
        if (end == -1) {
            return null;
        }
        return src.substring(start, end);
    }
}

