package net.dzultra.jfa.apidata;

import net.dzultra.jfa.exceptions.InvalidResponseException;
import net.dzultra.jfa.exceptions.NoExactMatchException;
import net.dzultra.jfa.requests.PlayerSearchRequest;
import net.dzultra.jfa.responses.PlayerSearchResponse;

import java.util.List;


public class PlayerSearch extends APIDataObject<PlayerSearchRequest,PlayerSearchResponse> {
    private PlayerSearchResponse.PlayerSearchResult playerSearchResult;

    private String uuid;
    private String username;
    private String headUrl;

    public PlayerSearch(String username) {
        this(new PlayerSearchRequest(username));
    }

    public PlayerSearch(PlayerSearchRequest request) {
        super(request, request.getResponse());
        dataHandler();
    }

    @Override
    protected void dataHandler() {
        List<PlayerSearchResponse.PlayerSearchResult> playerSearchResults = response.players();
        if (playerSearchResults == null) throw new InvalidResponseException(this);

        boolean foundExactMatch = false;
        int index = 0;
        for (PlayerSearchResponse.PlayerSearchResult result : playerSearchResults) {
            if (result.username().equalsIgnoreCase(this.getRequestedUsername())) {
                foundExactMatch = true;
                break;
            }
            index++;
        }
        if (!foundExactMatch) {
            throw new NoExactMatchException(this, username);
        }

        this.playerSearchResult = this.response.players().get(index);
        this.uuid = this.getPlayerSearchResult().uuid();
        this.username = this.getPlayerSearchResult().username();
        this.headUrl = this.getPlayerSearchResult().headUrl();
    }

    @Override
    public String getName() {
        return "PlayerSearch";
    }

    public String getUuid() {
        return uuid;
    }

    public String getUsername() {
        return username;
    }

    public String getHeadUrl() {
        return headUrl;
    }

    public String getRequestedUsername() {
        return this.request.getUsername();
    }

    private PlayerSearchResponse.PlayerSearchResult getPlayerSearchResult() {
        return this.playerSearchResult;
    }
}
