/*
 * Decompiled with CFR 0.152.
 */
package net.eulerframework.web.module.file.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import net.eulerframework.common.util.Assert;
import net.eulerframework.common.util.DateUtils;
import net.eulerframework.common.util.StringUtils;
import net.eulerframework.common.util.io.file.SimpleFileIOUtils;
import net.eulerframework.web.config.WebConfig;
import net.eulerframework.web.core.base.entity.BaseEntity;
import net.eulerframework.web.core.base.service.impl.BaseService;
import net.eulerframework.web.module.file.dao.IArchivedFileDao;
import net.eulerframework.web.module.file.entity.ArchivedFile;
import net.eulerframework.web.module.file.exception.FileArchiveException;
import net.eulerframework.web.module.file.util.WebFileTool;
import net.eulerframework.web.util.ServletUtils;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ArchivedFileService
extends BaseService {
    @Resource
    private IArchivedFileDao archivedFileDao;

    private ArchivedFile saveFileInfo(String originalFilename, String archivedPathSuffix, File archivedFile) throws IOException {
        FileInputStream inputStream = new FileInputStream(archivedFile);
        String md5 = DigestUtils.md5Hex((InputStream)inputStream);
        long fileSize = archivedFile.length();
        String archivedFilename = archivedFile.getName();
        ArchivedFile af = new ArchivedFile();
        af.setOriginalFilename(originalFilename);
        af.setArchivedPathSuffix(archivedPathSuffix);
        af.setArchivedFilename(archivedFilename);
        af.setExtension(WebFileTool.extractFileExtension(originalFilename));
        af.setFileByteSize(fileSize);
        af.setMd5(md5);
        af.setUploadedDate(new Date());
        Object userId = ServletUtils.getRequest().getAttribute("__USER_ID");
        if (userId != null) {
            af.setUploadedUserId(userId.toString());
        } else {
            af.setUploadedUserId("anonymousUser");
        }
        this.archivedFileDao.save((BaseEntity)af);
        return af;
    }

    public ArchivedFile saveFile(File file) throws FileArchiveException {
        String archiveFilePath = WebConfig.getUploadPath();
        String archivedPathSuffix = DateUtils.formatDate((Date)new Date(), (String)"yyyy-MM-dd");
        String originalFilename = file.getName();
        String targetFilename = UUID.randomUUID().toString();
        File targetFile = new File(archiveFilePath + "/" + archivedPathSuffix, targetFilename);
        try {
            Files.copy(file.toPath(), targetFile.toPath(), new CopyOption[0]);
            this.logger.info("\u5df2\u4fdd\u5b58\u6587\u4ef6: " + targetFile.getPath());
            return this.saveFileInfo(originalFilename, archivedPathSuffix, targetFile);
        }
        catch (IOException | IllegalStateException e) {
            if (targetFile.exists()) {
                SimpleFileIOUtils.deleteFile((File)targetFile);
            }
            throw new FileArchiveException(e);
        }
    }

    public ArchivedFile saveMultipartFile(MultipartFile multipartFile) throws FileArchiveException {
        String archiveFilePath = WebConfig.getUploadPath();
        String archivedPathSuffix = DateUtils.formatDate((Date)new Date(), (String)"yyyy-MM-dd");
        String originalFilename = multipartFile.getOriginalFilename();
        String targetFilename = UUID.randomUUID().toString();
        File targetFile = new File(archiveFilePath + "/" + archivedPathSuffix, targetFilename);
        if (!targetFile.getParentFile().exists()) {
            targetFile.getParentFile().mkdirs();
        }
        try {
            multipartFile.transferTo(targetFile);
            this.logger.info("\u5df2\u4fdd\u5b58\u6587\u4ef6: " + targetFile.getPath());
            return this.saveFileInfo(originalFilename, archivedPathSuffix, targetFile);
        }
        catch (IOException | IllegalStateException e) {
            if (targetFile.exists()) {
                SimpleFileIOUtils.deleteFile((File)targetFile);
            }
            throw new FileArchiveException(e);
        }
    }

    public ArchivedFile findArchivedFile(String archivedFileId) {
        Assert.isFalse((boolean)StringUtils.isNull((String)archivedFileId), (String)"archivedFileId is null");
        return (ArchivedFile)this.archivedFileDao.load((Serializable)((Object)archivedFileId));
    }

    public void deleteArchivedFile(String ... archivedFileId) {
        Assert.notNull((Object)archivedFileId);
        List archivedFile = this.archivedFileDao.load((Serializable[])archivedFileId);
        if (archivedFile == null) {
            return;
        }
        this.archivedFileDao.deleteByIds((Serializable[])archivedFileId);
        for (ArchivedFile each : archivedFile) {
            File file = WebFileTool.getArchivedFile(each);
            SimpleFileIOUtils.deleteFile((File)file);
        }
    }
}

