/*
 * Decompiled with CFR 0.152.
 */
package net.eulerframework.web.module.file.service;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.eulerframework.common.util.Assert;
import net.eulerframework.web.core.base.entity.BaseEntity;
import net.eulerframework.web.core.base.service.impl.BaseService;
import net.eulerframework.web.module.file.dao.IAttachmentDao;
import net.eulerframework.web.module.file.entity.AbstractAttachment;
import net.eulerframework.web.module.file.entity.AbstractFileAttachment;
import net.eulerframework.web.module.file.exception.AttachmentNotFoundException;

public class AttachmentService
extends BaseService {
    private Collection<IAttachmentDao<AbstractAttachment>> attachmentDaos;

    public void setAttachmentDaos(Collection<IAttachmentDao<AbstractAttachment>> attachmentDaos) {
        this.attachmentDaos = attachmentDaos;
    }

    public void addAttachment(AbstractAttachment attachment) {
        Assert.notNull((Object)((Object)attachment), (String)"attachment is null");
        Assert.notNull((Object)attachment.getOwnerId(), (String)"attachment owner id is null");
        ((IAttachmentDao)this.getEntityDao(this.attachmentDaos, ((Object)((Object)attachment)).getClass())).save((BaseEntity)attachment);
    }

    public void updateAttachment(AbstractAttachment attachment) {
        Assert.notNull((Object)((Object)attachment), (String)"attachment is null");
        Assert.notNull((Object)attachment.getOwnerId(), (String)"attachment owner id is null");
        ((IAttachmentDao)this.getEntityDao(this.attachmentDaos, ((Object)((Object)attachment)).getClass())).saveOrUpdate((BaseEntity)attachment);
    }

    public void deleteAttachment(AbstractAttachment attachment) {
        Assert.notNull((Object)((Object)attachment), (String)"attachment is null");
        Assert.notNull((Object)attachment.getOwnerId(), (String)"attachment owner id is null");
        ((IAttachmentDao)this.getEntityDao(this.attachmentDaos, ((Object)((Object)attachment)).getClass())).deleteById((Serializable)((Object)attachment.getId()));
    }

    public <T extends AbstractAttachment> void deleteAttachment(Serializable ownerId, String attachmentId, Class<T> attachmentClass) throws AttachmentNotFoundException {
        Assert.notNull((Object)ownerId, (String)"attachment owner id is null");
        Assert.notNull((Object)attachmentId, (String)"attachment id is null");
        IAttachmentDao dao = (IAttachmentDao)this.getEntityDao(this.attachmentDaos, attachmentClass);
        AbstractAttachment data = (AbstractAttachment)dao.load((Serializable)((Object)attachmentId));
        if (data == null || !data.getOwnerId().equals(ownerId)) {
            throw new AttachmentNotFoundException("Attachment id is " + attachmentId + " and owner id is " + ownerId + " not found");
        }
        dao.deleteById((Serializable)((Object)attachmentId));
        if (AbstractFileAttachment.class.isAssignableFrom(attachmentClass)) {
            String fileId = ((AbstractFileAttachment)data).getFileId();
            System.out.println("delete archived file " + fileId);
        }
    }

    public <T extends AbstractAttachment> void deleteAllAttachment(Serializable ownerId, Class<T> attachmentClass) {
        Assert.notNull((Object)ownerId, (String)"attachment owner id is null");
        List<T> data = this.loadAttachments(ownerId, attachmentClass);
        if (data == null || data.isEmpty()) {
            return;
        }
        IAttachmentDao dao = (IAttachmentDao)this.getEntityDao(this.attachmentDaos, attachmentClass);
        HashSet<String> ids = new HashSet<String>();
        for (AbstractAttachment each : data) {
            ids.add(each.getId());
        }
        dao.deleteByIds(ids);
        if (AbstractFileAttachment.class.isAssignableFrom(attachmentClass)) {
            HashSet<String> fileIdSet = new HashSet<String>();
            for (AbstractAttachment each : data) {
                fileIdSet.add(((AbstractFileAttachment)each).getFileId());
            }
            if (!fileIdSet.isEmpty()) {
                System.out.println("delete archived file " + fileIdSet);
            }
        }
    }

    public <T extends AbstractAttachment> T loadAttachment(Serializable ownerId, Class<T> attachmentClass) {
        Assert.notNull((Object)ownerId, (String)"attachment owner id is null");
        List<T> data = this.loadAttachments(ownerId, attachmentClass);
        if (data == null || data.isEmpty()) {
            return null;
        }
        return (T)((Object)((AbstractAttachment)((Object)data.get(0))));
    }

    public <T extends AbstractAttachment> List<T> loadAttachments(Serializable ownerId, Class<T> attachmentClass) {
        Assert.notNull((Object)ownerId, (String)"attachment owner id is null");
        IAttachmentDao dao = (IAttachmentDao)this.getEntityDao(this.attachmentDaos, attachmentClass);
        return dao.loadByOwnerId(ownerId);
    }
}

