/*
 * Decompiled with CFR 0.152.
 */
package net.fckeditor.tool;

import java.io.File;
import java.io.InputStream;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import net.fckeditor.handlers.ConnectorHandler;
import net.fckeditor.handlers.ResourceTypeHandler;
import net.fckeditor.tool.Utils;
import org.devlib.schmidt.imageinfo.ImageInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UtilsFile {
    protected static final Pattern ILLEGAL_CURRENT_FOLDER_PATTERN = Pattern.compile("^[^/]|[^/]$|/\\.{1,2}|\\\\|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}");
    private static final Logger logger = LoggerFactory.getLogger((Class)UtilsFile.class);

    public static String sanitizeFileName(String fileName) {
        if (fileName == null) {
            return null;
        }
        if (fileName.equals("")) {
            return "";
        }
        String name = ConnectorHandler.isForceSingleExtension() ? UtilsFile.forceSingleExtension(fileName) : fileName;
        return name.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
    }

    public static String sanitizeFolderName(String folderName) {
        if (folderName == null) {
            return null;
        }
        if (folderName.equals("")) {
            return "";
        }
        return folderName.replaceAll("\\.|\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
    }

    public static boolean isImage(InputStream in) {
        ImageInfo ii = new ImageInfo();
        ii.setInput(in);
        return ii.check();
    }

    public static boolean isValidPath(String path) {
        if (Utils.isEmpty(path)) {
            return false;
        }
        return !ILLEGAL_CURRENT_FOLDER_PATTERN.matcher(path).find();
    }

    public static String forceSingleExtension(String filename) {
        return filename.replaceAll("\\.(?![^.]+$)", "_");
    }

    public static boolean isSingleExtension(String filename) {
        return filename.matches("[^\\.]+\\.[^\\.]+");
    }

    public static void checkDirAndCreate(File dir) {
        if (!dir.exists()) {
            dir.mkdirs();
            logger.debug("Dir '{}' successfully created", (Object)dir);
        }
    }

    public static String constructServerSidePath(HttpServletRequest request, ResourceTypeHandler resourceType) {
        StringBuffer sb = new StringBuffer(ConnectorHandler.getUserFilesPath(request));
        sb.append(resourceType.getPath());
        return sb.toString();
    }
}

