/*
 * Decompiled with CFR 0.152.
 */
package net.fckeditor.tool;

import java.io.File;
import java.io.InputStream;
import java.util.regex.Pattern;
import net.fckeditor.handlers.PropertiesLoader;
import net.fckeditor.tool.Utils;
import org.apache.commons.io.FilenameUtils;
import org.devlib.schmidt.imageinfo.ImageInfo;

public class UtilsFile {
    protected static final Pattern ILLEGAL_CURRENT_FOLDER_PATTERN = Pattern.compile("^[^/]|[^/]$|/\\.{1,2}|\\\\|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}");

    public static String sanitizeFileName(String filename) {
        if (Utils.isEmpty(filename)) {
            return filename;
        }
        String name = PropertiesLoader.isForceSingleExtension() ? UtilsFile.forceSingleExtension(filename) : filename;
        return name.replaceAll("\\\\|/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
    }

    public static String sanitizeFolderName(String folderName) {
        if (Utils.isEmpty(folderName)) {
            return folderName;
        }
        return folderName.replaceAll("\\.|\\\\|/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
    }

    public static boolean isImage(InputStream in) {
        ImageInfo ii = new ImageInfo();
        ii.setInput(in);
        return ii.check();
    }

    public static boolean isValidPath(String path) {
        if (Utils.isEmpty(path)) {
            return false;
        }
        return !ILLEGAL_CURRENT_FOLDER_PATTERN.matcher(path).find();
    }

    public static String forceSingleExtension(String filename) {
        return filename.replaceAll("\\.(?![^.]+$)", "_");
    }

    public static boolean isSingleExtension(String filename) {
        return filename.matches("[^\\.]+\\.[^\\.]+");
    }

    public static void checkDirAndCreate(File dir) {
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }

    public static File getUniqueFile(File file) {
        if (!file.exists()) {
            return file;
        }
        File tmpFile = new File(file.getAbsolutePath());
        File parentDir = tmpFile.getParentFile();
        int count = 1;
        String extension = FilenameUtils.getExtension((String)tmpFile.getName());
        String baseName = FilenameUtils.getBaseName((String)tmpFile.getName());
        while ((tmpFile = new File(parentDir, baseName + "(" + count++ + ")." + extension)).exists()) {
        }
        return tmpFile;
    }
}

