/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.user.command.handler;

import com.networknt.monad.Failure;
import com.networknt.monad.Result;
import com.networknt.monad.Success;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.status.Status;
import io.undertow.server.HttpServerExchange;
import java.util.Map;
import net.lightapi.portal.HybridQueryClient;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/user/cancelOrder/0.1.0")
public class CancelOrder
extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(CancelOrder.class);

    protected String getCloudEventType() {
        return "OrderCancelledEvent";
    }

    protected Logger getLogger() {
        return logger;
    }

    protected Result<Map<String, Object>> enrichInput(HttpServerExchange exchange, Map<String, Object> map) {
        String merchantUserId = (String)map.get("merchantUserId");
        Result resultId = HybridQueryClient.getUserById((HttpServerExchange)exchange, (String)merchantUserId);
        if (resultId.isFailure()) {
            return Failure.of((Status)resultId.getError());
        }
        String merchantEmail = (String)resultId.getResult();
        map.put("merchantEmail", merchantEmail);
        return Success.of(map);
    }
}

