/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.user.command.handler;

import com.networknt.monad.Failure;
import com.networknt.monad.Result;
import com.networknt.monad.Success;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.status.Status;
import com.networknt.utility.HashUtil;
import io.undertow.server.HttpServerExchange;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Map;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/user/changePassword/0.1.0")
public class ChangePassword
extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(ChangePassword.class);
    private static final String PASSWORD_NOT_MATCH = "ERR11613";
    private static final String ERROR_HASHING_PASSWORD = "ERR11614";

    protected String getCloudEventType() {
        return "PasswordChangedEvent";
    }

    protected Logger getLogger() {
        return logger;
    }

    protected Result<Map<String, Object>> validateInput(HttpServerExchange exchange, Map<String, Object> map, String userId, String host) {
        String passwordConfirm;
        String oldPassword = (String)map.get("oldPassword");
        String newPassword = (String)map.get("newPassword");
        if (newPassword.equals(passwordConfirm = (String)map.get("passwordConfirm"))) {
            try {
                newPassword = HashUtil.generateStrongPasswordHash((String)newPassword);
                oldPassword = HashUtil.generateStrongPasswordHash((String)oldPassword);
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                logger.error("NoSuchAlgorithmException", (Throwable)e);
                return Failure.of((Status)new Status(ERROR_HASHING_PASSWORD, new Object[]{e.getMessage()}));
            }
        } else {
            return Failure.of((Status)new Status(PASSWORD_NOT_MATCH, new Object[]{userId}));
        }
        return Success.of(map);
    }
}

