/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.user.command.handler;

import com.networknt.monad.Failure;
import com.networknt.monad.Result;
import com.networknt.monad.Success;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.status.Status;
import io.undertow.server.HttpServerExchange;
import java.util.Map;
import net.lightapi.portal.HybridQueryClient;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/user/confirmUser/0.1.0")
public class ConfirmUser
extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(ConfirmUser.class);

    protected String getCloudEventType() {
        return "UserConfirmedEvent";
    }

    protected Logger getLogger() {
        return logger;
    }

    protected Result<Map<String, Object>> validateInput(HttpServerExchange exchange, Map<String, Object> map, String userId, String host) {
        String email = (String)map.get("email");
        Result result = HybridQueryClient.getUserByEmail((HttpServerExchange)exchange, (String)email);
        if (result.isFailure()) {
            return Failure.of((Status)result.getError());
        }
        return Success.of(map);
    }

    protected String customizeOutput(Map<String, Object> map) {
        return "Thanks you for your email confirmation!";
    }
}

