/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.user.command.handler;

import com.networknt.client.oauth.ClientCredentialsRequest;
import com.networknt.client.oauth.OauthHelper;
import com.networknt.client.oauth.TokenRequest;
import com.networknt.client.oauth.TokenResponse;
import com.networknt.config.Config;
import com.networknt.config.JsonMapper;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.kafka.common.AvroSerializer;
import com.networknt.kafka.common.EventId;
import com.networknt.monad.Result;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.utility.ByteUtil;
import com.networknt.utility.NioUtils;
import com.networknt.utility.UuidUtil;
import io.undertow.server.HttpServerExchange;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import net.lightapi.portal.HybridQueryClient;
import net.lightapi.portal.PortalConfig;
import net.lightapi.portal.command.HybridCommandStartup;
import net.lightapi.portal.user.OrderCreatedEvent;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/user/createOrder/0.1.0")
public class CreateOrder
implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(CreateOrder.class);
    private static final PortalConfig config = (PortalConfig)Config.getInstance().getJsonObjectConfig("portal", PortalConfig.class);
    private static final String INCORRECT_TOKEN_TYPE = "ERR11601";
    private static final String SEND_MESSAGE_EXCEPTION = "ERR11605";
    AvroSerializer serializer = new AvroSerializer();

    public ByteBuffer handle(HttpServerExchange exchange, Object input) {
        if (logger.isTraceEnabled()) {
            logger.trace("input = " + String.valueOf(input));
        }
        Map map = (Map)input;
        String hostId = (String)map.get("hostId");
        String merchantUserId = (String)map.get("userId");
        Map order = (Map)map.get("order");
        Map auditInfo = (Map)exchange.getAttachment(AttachmentConstants.AUDIT_INFO);
        String userId = (String)auditInfo.get("user_id");
        if (userId == null) {
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, INCORRECT_TOKEN_TYPE, new Object[]{"Authorization Code Token"}));
        }
        ClientCredentialsRequest tokenRequest = new ClientCredentialsRequest();
        Result resultJwt = OauthHelper.getTokenResult((TokenRequest)tokenRequest);
        if (resultJwt.isFailure()) {
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, resultJwt.getError()));
        }
        Result resultEmail = HybridQueryClient.getUserById((String)merchantUserId, (String)((TokenResponse)resultJwt.getResult()).getAccessToken());
        if (resultEmail.isFailure()) {
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, resultEmail.getError()));
        }
        String merchantEmail = (String)resultEmail.getResult();
        Result result = HybridQueryClient.getNonceByUserId((HttpServerExchange)exchange, (String)userId);
        if (result.isFailure()) {
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, result.getError()));
        }
        long nonce = Long.parseLong((String)result.getResult());
        String orderId = UuidUtil.getUUID().toString();
        order.put("orderId", orderId);
        String passCode = ByteUtil.randomNumeric((int)2) + ByteUtil.randomAlphabetic((int)2);
        order.put("passCode", passCode);
        order.put("status", "Confirmed");
        order.put("timestamp", System.currentTimeMillis());
        EventId eventId = EventId.newBuilder().setId(UuidUtil.getUUID().toString()).setHostId(hostId).setUserId(userId).setNonce(nonce).setTimestamp(System.currentTimeMillis()).build();
        OrderCreatedEvent event = OrderCreatedEvent.newBuilder().setEventId(eventId).setHostId(hostId).setEmail(merchantEmail).setOrder(JsonMapper.toJson(map.get("order"))).build();
        byte[] merchantBytes = this.serializer.serialize((Object)event);
        ProducerRecord merchantRecord = new ProducerRecord(config.getTopic(), (Object)(config.isMultitenancy() ? hostId : userId).getBytes(StandardCharsets.UTF_8), (Object)merchantBytes);
        event.setEmail(userId);
        byte[] customerBytes = this.serializer.serialize((Object)event);
        ProducerRecord customerRecord = new ProducerRecord(config.getTopic(), (Object)userId.getBytes(StandardCharsets.UTF_8), (Object)customerBytes);
        CountDownLatch latch = new CountDownLatch(2);
        try {
            HybridCommandStartup.producer.send(merchantRecord, (recordMetadata, e) -> {
                if (Objects.nonNull(e)) {
                    logger.error("Exception occurred while pushing the event", (Throwable)e);
                } else {
                    logger.info("Event record pushed successfully. Received Record Metadata is {}", (Object)recordMetadata);
                }
                latch.countDown();
            });
            HybridCommandStartup.producer.send(customerRecord, (recordMetadata, e) -> {
                if (Objects.nonNull(e)) {
                    logger.error("Exception occurred while pushing the event", (Throwable)e);
                } else {
                    logger.info("Event record pushed successfully. Received Record Metadata is {}", (Object)recordMetadata);
                }
                latch.countDown();
            });
            latch.await();
        }
        catch (InterruptedException e2) {
            logger.error("Exception:", (Throwable)e2);
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, SEND_MESSAGE_EXCEPTION, new Object[]{e2.getMessage(), config.isMultitenancy() ? hostId : userId}));
        }
        HashMap<String, Object> r = new HashMap<String, Object>();
        r.put("orderId", orderId);
        r.put("passCode", passCode);
        return NioUtils.toByteBuffer((String)JsonMapper.toJson(r));
    }
}

