/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.user.command.handler;

import com.networknt.config.Config;
import com.networknt.config.JsonMapper;
import com.networknt.kafka.common.AvroSerializer;
import com.networknt.kafka.common.EventId;
import com.networknt.monad.Result;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.utility.NioUtils;
import com.networknt.utility.UuidUtil;
import io.undertow.server.HttpServerExchange;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import net.lightapi.portal.HybridQueryClient;
import net.lightapi.portal.PortalConfig;
import net.lightapi.portal.command.HybridCommandStartup;
import net.lightapi.portal.user.SocialUserCreatedEvent;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/user/createSocialUser/0.1.0")
public class CreateSocialUser
implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(CreateSocialUser.class);
    private static final PortalConfig config = (PortalConfig)Config.getInstance().getJsonObjectConfig("portal", PortalConfig.class);
    private static final String USER_ID_IS_USED = "ERR11604";
    private static final String USER_EMAIL_IS_USED = "ERR11611";
    private static final String EMAIL_SENDING_ERROR = "ERR11619";
    private static final String SEND_MESSAGE_EXCEPTION = "ERR11605";
    AvroSerializer serializer = new AvroSerializer();

    public ByteBuffer handle(HttpServerExchange exchange, Object input) {
        if (logger.isTraceEnabled()) {
            logger.trace("input = " + String.valueOf(input));
        }
        Map map = (Map)input;
        String email = (String)map.get("email");
        String userId = (String)map.get("userId");
        String hostId = (String)map.get("hostId");
        Result resultEmail = HybridQueryClient.getUserByEmail((HttpServerExchange)exchange, (String)email);
        if (resultEmail.isSuccess()) {
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, USER_EMAIL_IS_USED, new Object[]{email}));
        }
        if (resultEmail.getError().getStatusCode() != 404) {
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, resultEmail.getError()));
        }
        Result resultId = HybridQueryClient.getUserById((HttpServerExchange)exchange, (String)userId);
        if (resultId.isSuccess()) {
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, USER_ID_IS_USED, new Object[]{userId}));
        }
        if (resultId.getError().getStatusCode() != 404) {
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, resultId.getError()));
        }
        EventId eventId = EventId.newBuilder().setId(UuidUtil.getUUID().toString()).setHostId(hostId).setUserId(userId).setNonce(1L).setTimestamp(System.currentTimeMillis()).build();
        HashMap valueMap = new HashMap();
        valueMap.put("firstName", map.get("firstName"));
        valueMap.put("lastName", map.get("lastName"));
        SocialUserCreatedEvent event = SocialUserCreatedEvent.newBuilder().setEventId(eventId).setHostId(hostId).setEmail(email).setUserId(userId).setLanguage((String)map.get("language")).setValue(JsonMapper.toJson(valueMap)).setRoles("user").setVerified(true).build();
        byte[] bytes = this.serializer.serialize((Object)event);
        ProducerRecord record = new ProducerRecord(config.getTopic(), (Object)(config.isMultitenancy() ? hostId : userId).getBytes(StandardCharsets.UTF_8), (Object)bytes);
        CountDownLatch latch = new CountDownLatch(1);
        try {
            HybridCommandStartup.producer.send(record, (recordMetadata, e) -> {
                if (Objects.nonNull(e)) {
                    logger.error("Exception occurred while pushing the event", (Throwable)e);
                } else {
                    logger.info("Event record pushed successfully. Received Record Metadata is {}", (Object)recordMetadata);
                }
                latch.countDown();
            });
            latch.await();
        }
        catch (InterruptedException e2) {
            logger.error("Exception:", (Throwable)e2);
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, SEND_MESSAGE_EXCEPTION, new Object[]{e2.getMessage(), config.isMultitenancy() ? hostId : userId}));
        }
        return NioUtils.toByteBuffer((String)this.getStatus(exchange, "SUC10200", new Object[0]));
    }
}

