/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.user.command.handler;

import com.networknt.config.Config;
import com.networknt.config.JsonMapper;
import com.networknt.email.EmailSender;
import com.networknt.monad.Result;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.utility.HashUtil;
import com.networknt.utility.NioUtils;
import com.networknt.utility.UuidUtil;
import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.undertow.server.HttpServerExchange;
import jakarta.mail.MessagingException;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import net.lightapi.portal.HybridQueryClient;
import net.lightapi.portal.PortalConfig;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.HybridCommandStartup;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/user/createUser/0.1.0")
public class CreateUser
implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(CreateUser.class);
    private static final PortalConfig config = (PortalConfig)Config.getInstance().getJsonObjectConfig("portal", PortalConfig.class);
    private static final String USER_ID_IS_USED = "ERR11604";
    private static final String USER_EMAIL_IS_USED = "ERR11611";
    private static final String PASSWORD_NOT_MATCH = "ERR11613";
    private static final String ERROR_HASHING_PASSWORD = "ERR11614";
    private static final String EMAIL_SENDING_ERROR = "ERR11619";
    private static final String SEND_MESSAGE_EXCEPTION = "ERR11605";

    public ByteBuffer handle(HttpServerExchange exchange, Object input) {
        String passwordConfirm;
        if (logger.isTraceEnabled()) {
            logger.trace("input = {}", input);
        }
        Map map = (Map)input;
        String hostId = (String)map.get("hostId");
        String email = (String)map.get("email");
        String entityId = (String)map.get("entityId");
        String userType = (String)map.get("userType");
        Result resultEmail = HybridQueryClient.getUserByEmail((HttpServerExchange)exchange, (String)email);
        if (resultEmail.isSuccess()) {
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, USER_EMAIL_IS_USED, new Object[]{email}));
        }
        if (resultEmail.getError().getStatusCode() != 404) {
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, resultEmail.getError()));
        }
        Result resultId = HybridQueryClient.getUserByTypeEntityId((HttpServerExchange)exchange, (String)userType, (String)entityId);
        if (resultId.isSuccess()) {
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, USER_ID_IS_USED, new Object[]{entityId}));
        }
        if (resultId.getError().getStatusCode() != 404) {
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, resultId.getError()));
        }
        String password = (String)map.get("password");
        if (password.equals(passwordConfirm = (String)map.get("passwordConfirm"))) {
            try {
                String hashedPass = HashUtil.generateStrongPasswordHash((String)password);
                map.put("password", hashedPass);
                map.remove("passwordConfirm");
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException e2) {
                logger.error("NoSuchAlgorithmException", (Throwable)e2);
                return NioUtils.toByteBuffer((String)this.getStatus(exchange, ERROR_HASHING_PASSWORD, new Object[]{e2.getMessage()}));
            }
        } else {
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, PASSWORD_NOT_MATCH, new Object[]{email}));
        }
        String emailToken = UUID.randomUUID().toString();
        String userId = UuidUtil.getUUID().toString();
        map.put("userId", userId);
        map.put("emailToken", emailToken);
        map.put("verified", false);
        io.cloudevents.core.v1.CloudEventBuilder eventTemplate = CloudEventBuilder.v1().withSource(PortalConstants.EVENT_SOURCE).withType("UserCreatedEvent");
        String data = JsonMapper.toJson((Object)map);
        CloudEvent event = eventTemplate.newBuilder().withId(UuidUtil.getUUID().toString()).withTime(OffsetDateTime.now()).withExtension("user", userId).withExtension("nonce", (Number)1).withExtension("host", hostId).withData("application/json", data.getBytes(StandardCharsets.UTF_8)).build();
        ProducerRecord record = new ProducerRecord(config.getTopic(), (Object)(config.isMultitenancy() ? hostId : userId), (Object)event);
        CountDownLatch latch = new CountDownLatch(1);
        try {
            HybridCommandStartup.producer.send(record, (recordMetadata, e) -> {
                if (Objects.nonNull(e)) {
                    logger.error("Exception occurred while pushing the event", (Throwable)e);
                } else {
                    logger.info("Event record pushed successfully. Received Record Metadata is {}", (Object)recordMetadata);
                }
                latch.countDown();
            });
            latch.await();
        }
        catch (InterruptedException e3) {
            logger.error("Exception:", (Throwable)e3);
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, SEND_MESSAGE_EXCEPTION, new Object[]{e3.getMessage(), config.isMultitenancy() ? hostId : userId}));
        }
        if (config.isSendEmail()) {
            EmailSender sender = new EmailSender();
            try {
                String content = this.getEmailContent(hostId, email, emailToken);
                sender.sendMail(email, "New User Registration Confirmation", content);
            }
            catch (MessagingException e4) {
                logger.error("Failed to send email ", (Throwable)e4);
                return NioUtils.toByteBuffer((String)this.getStatus(exchange, EMAIL_SENDING_ERROR, new Object[]{config.isMultitenancy() ? hostId : userId}));
            }
        }
        return NioUtils.toByteBuffer((String)this.getStatus(exchange, "SUC10200", new Object[0]));
    }

    public String getEmailContent(String hostId, String email, String token) {
        String content = null;
        String hostUrl = config.getCmdHost() + config.getCmdPath();
        String cmd = String.format("{\"host\":\"lightapi.net\",\"service\":\"user\",\"action\":\"confirmUser\",\"version\":\"0.1.0\",\"data\":{\"hostId\":\"%s\",\"email\":\"%s\",\"token\":\"%s\"}}", hostId, email, token);
        try {
            String url = hostUrl + URLEncoder.encode(cmd, "UTF-8");
            logger.debug("url = {}", (Object)url);
            String template = Config.getInstance().getStringFromFile("email-confirmation-template.html");
            HashMap<String, CallSite> map = new HashMap<String, CallSite>();
            map.put("link", (CallSite)((Object)url));
            content = EmailSender.replaceTokens((String)template, map);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("UnsupportedEncodingException while encode cmd = {}", (Object)cmd, (Object)e);
        }
        return content;
    }
}

