/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.user.command.handler;

import com.networknt.config.Config;
import com.networknt.config.JsonMapper;
import com.networknt.email.EmailSender;
import com.networknt.kafka.common.AvroSerializer;
import com.networknt.monad.Result;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.utility.NioUtils;
import com.networknt.utility.UuidUtil;
import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.undertow.server.HttpServerExchange;
import jakarta.mail.MessagingException;
import java.lang.invoke.CallSite;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import net.lightapi.portal.HybridQueryClient;
import net.lightapi.portal.PortalConfig;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.HybridCommandStartup;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/user/forgetPassword/0.1.0")
public class ForgetPassword
implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(ForgetPassword.class);
    private static final PortalConfig config = (PortalConfig)Config.getInstance().getJsonObjectConfig("portal", PortalConfig.class);
    private static final String SEND_MESSAGE_EXCEPTION = "ERR11605";
    private static final String EMAIL_SENDING_ERROR = "ERR11619";
    AvroSerializer serializer = new AvroSerializer();

    public ByteBuffer handle(HttpServerExchange exchange, Object input) {
        if (logger.isTraceEnabled()) {
            logger.trace("input = " + String.valueOf(input));
        }
        Map map = (Map)input;
        String hostId = (String)map.get("hostId");
        String email = (String)map.get("email");
        Result resultUser = HybridQueryClient.getUserByEmail((HttpServerExchange)exchange, (String)email);
        if (resultUser.isFailure()) {
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, resultUser.getError()));
        }
        String userId = JsonMapper.string2Map((String)((String)resultUser.getResult())).get("userId").toString();
        Result result = HybridQueryClient.getNonceByUserId((HttpServerExchange)exchange, (String)userId);
        if (result.isSuccess()) {
            long nonce = Long.parseLong((String)result.getResult());
            String forgetPasswordToken = UUID.randomUUID().toString();
            map.put("token", forgetPasswordToken);
            io.cloudevents.core.v1.CloudEventBuilder eventTemplate = CloudEventBuilder.v1().withSource(PortalConstants.EVENT_SOURCE).withType("PasswordForgotEvent");
            String data = JsonMapper.toJson((Object)map);
            CloudEvent event = eventTemplate.newBuilder().withId(UuidUtil.getUUID().toString()).withTime(OffsetDateTime.now()).withExtension("user", userId).withExtension("nonce", (Number)nonce).withExtension("host", hostId).withData("application/json", data.getBytes(StandardCharsets.UTF_8)).build();
            ProducerRecord record = new ProducerRecord(config.getTopic(), (Object)(config.isMultitenancy() ? hostId : userId), (Object)event);
            CountDownLatch latch = new CountDownLatch(1);
            try {
                HybridCommandStartup.producer.send(record, (recordMetadata, e) -> {
                    if (Objects.nonNull(e)) {
                        logger.error("Exception occurred while pushing the event", (Throwable)e);
                    } else {
                        logger.info("Event record pushed successfully. Received Record Metadata is {}", (Object)recordMetadata);
                    }
                    latch.countDown();
                });
                latch.await();
            }
            catch (InterruptedException e2) {
                logger.error("Exception:", (Throwable)e2);
                return NioUtils.toByteBuffer((String)this.getStatus(exchange, SEND_MESSAGE_EXCEPTION, new Object[]{e2.getMessage(), config.isMultitenancy() ? hostId : userId}));
            }
            if (config.isSendEmail()) {
                EmailSender sender = new EmailSender();
                try {
                    String content = this.getEmailContent(email, forgetPasswordToken);
                    sender.sendMail(email, "Reset Password of Light Portal", content);
                }
                catch (MessagingException e3) {
                    logger.error("Failed to send email ", (Throwable)e3);
                    return NioUtils.toByteBuffer((String)this.getStatus(exchange, EMAIL_SENDING_ERROR, new Object[]{userId}));
                }
            }
        } else {
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, result.getError()));
        }
        return NioUtils.toByteBuffer((String)this.getStatus(exchange, "SUC10200", new Object[0]));
    }

    private String getEmailContent(String email, String token) {
        String hostUrl = config.getResetHost() + "/#/reset?token=" + token + "&email=" + email;
        logger.debug("hostUrl = {}", (Object)hostUrl);
        String template = Config.getInstance().getStringFromFile("forget-password-template.html");
        HashMap<String, CallSite> map = new HashMap<String, CallSite>();
        map.put("link", (CallSite)((Object)hostUrl));
        return EmailSender.replaceTokens((String)template, map);
    }
}

