/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.user.command.handler;

import com.networknt.config.Config;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.utility.NioUtils;
import io.undertow.server.HttpServerExchange;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import net.lightapi.portal.PortalConfig;
import net.lightapi.portal.command.HybridCommandStartup;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/user/importPortalEvent/0.1.0")
public class ImportPortalEvent
implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(ImportPortalEvent.class);
    protected static final String INCORRECT_TOKEN_TYPE = "ERR11601";
    protected static final PortalConfig config = (PortalConfig)Config.getInstance().getJsonObjectConfig("portal", PortalConfig.class);

    public ByteBuffer handle(HttpServerExchange exchange, Object input) {
        block14: {
            Map auditInfo;
            String userId;
            Map map = (Map)input;
            String hostId = (String)map.get("hostId");
            String portalServices = (String)map.get("portalServices");
            String startTs = (String)map.get("startTs");
            String endTs = (String)map.get("endTs");
            String eventText = (String)map.get("eventText");
            String eventUrl = (String)map.get("eventUrl");
            if (logger.isTraceEnabled()) {
                logger.trace("hostId = {}, portalServices = {}, startTs = {}, endTs = {}, eventText = {}, eventUrl = {}", new Object[]{hostId, portalServices, startTs, endTs, eventText, eventUrl});
            }
            if ((userId = (String)(auditInfo = (Map)exchange.getAttachment(AttachmentConstants.AUDIT_INFO)).get("user_id")) == null) {
                logger.error("Incorrect token type: userId is null. Must be Authorization Code Token.");
                return NioUtils.toByteBuffer((String)this.getStatus(exchange, INCORRECT_TOKEN_TYPE, new Object[]{"Authorization Code Token"}));
            }
            try {
                if (eventText != null && !eventText.isEmpty()) {
                    String[] lines;
                    for (String line : lines = eventText.split("\n")) {
                        String[] kv = line.split(" ");
                        if (kv.length != 2) continue;
                        String key = kv[0];
                        String value = kv[1];
                        if (logger.isTraceEnabled()) {
                            logger.trace("key = {}, value = {}", (Object)key, (Object)value);
                        }
                        this.pushToPortalEventTopic(key, value);
                    }
                    break block14;
                }
                URI uri = URI.create(eventUrl);
                URL url = uri.toURL();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        String[] kv = line.split(" ");
                        if (kv.length != 2) continue;
                        String key = kv[0];
                        String value = kv[1];
                        if (logger.isTraceEnabled()) {
                            logger.trace("key = {}, value = {}", (Object)key, (Object)value);
                        }
                        this.pushToPortalEventTopic(key, value);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return NioUtils.toByteBuffer((String)"");
    }

    private void pushToPortalEventTopic(String key, String value) {
        if (logger.isTraceEnabled()) {
            logger.trace("Pushing to portal event topic: key = {}, value = {}", (Object)key, (Object)value);
        }
        ProducerRecord record = new ProducerRecord(config.getTopic(), (Object)key, (Object)value.getBytes(StandardCharsets.UTF_8));
        CountDownLatch latch = new CountDownLatch(1);
        try {
            HybridCommandStartup.producer.send(record, (recordMetadata, e) -> {
                if (Objects.nonNull(e)) {
                    logger.error("Exception occurred while pushing the event", (Throwable)e);
                } else {
                    logger.info("Event record pushed successfully. Received Record Metadata is {}", (Object)recordMetadata);
                }
                latch.countDown();
            });
            latch.await();
        }
        catch (InterruptedException e2) {
            logger.error("Exception:", (Throwable)e2);
        }
    }
}

