/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.user.command.handler;

import com.networknt.config.Config;
import com.networknt.config.JsonMapper;
import com.networknt.kafka.common.AvroSerializer;
import com.networknt.monad.Result;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.utility.HashUtil;
import com.networknt.utility.NioUtils;
import com.networknt.utility.UuidUtil;
import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.undertow.server.HttpServerExchange;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import net.lightapi.portal.HybridQueryClient;
import net.lightapi.portal.PortalConfig;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.HybridCommandStartup;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/user/resetPassword/0.1.0")
public class ResetPassword
implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(ResetPassword.class);
    private static final PortalConfig config = (PortalConfig)Config.getInstance().getJsonObjectConfig("portal", PortalConfig.class);
    private static final String PASSWORD_NOT_MATCH = "ERR11613";
    private static final String ERROR_HASHING_PASSWORD = "ERR11614";
    private static final String SEND_MESSAGE_EXCEPTION = "ERR11605";
    AvroSerializer serializer = new AvroSerializer();

    public ByteBuffer handle(HttpServerExchange exchange, Object input) {
        String passwordConfirm;
        if (logger.isTraceEnabled()) {
            logger.trace("input = " + String.valueOf(input));
        }
        Map map = (Map)input;
        String email = (String)map.get("email");
        String hostId = (String)map.get("hostId");
        String token = (String)map.get("token");
        String newPassword = (String)map.get("newPassword");
        if (newPassword.equals(passwordConfirm = (String)map.get("passwordConfirm"))) {
            try {
                newPassword = HashUtil.generateStrongPasswordHash((String)newPassword);
                map.put("password", newPassword);
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException e2) {
                logger.error("NoSuchAlgorithmException", (Throwable)e2);
                return NioUtils.toByteBuffer((String)this.getStatus(exchange, ERROR_HASHING_PASSWORD, new Object[]{e2.getMessage()}));
            }
        } else {
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, PASSWORD_NOT_MATCH, new Object[]{email}));
        }
        Result userResult = HybridQueryClient.getUserByEmail((HttpServerExchange)exchange, (String)email);
        if (userResult.isFailure()) {
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, userResult.getError()));
        }
        Map userMap = JsonMapper.string2Map((String)((String)userResult.getResult()));
        String userId = (String)userMap.get("userId");
        Result result = HybridQueryClient.getNonceByUserId((HttpServerExchange)exchange, (String)userId);
        if (result.isSuccess()) {
            long nonce = Long.parseLong((String)result.getResult());
            io.cloudevents.core.v1.CloudEventBuilder eventTemplate = CloudEventBuilder.v1().withSource(PortalConstants.EVENT_SOURCE).withType("PasswordResetEvent");
            String data = JsonMapper.toJson((Object)map);
            CloudEvent event = eventTemplate.newBuilder().withId(UuidUtil.getUUID().toString()).withTime(OffsetDateTime.now()).withExtension("user", userId).withExtension("nonce", (Number)nonce).withExtension("host", hostId).withData("application/json", data.getBytes(StandardCharsets.UTF_8)).build();
            ProducerRecord record = new ProducerRecord(config.getTopic(), (Object)(config.isMultitenancy() ? hostId : userId), (Object)event);
            CountDownLatch latch = new CountDownLatch(1);
            try {
                HybridCommandStartup.producer.send(record, (recordMetadata, e) -> {
                    if (Objects.nonNull(e)) {
                        logger.error("Exception occurred while pushing the event", (Throwable)e);
                    } else {
                        logger.info("Event record pushed successfully. Received Record Metadata is {}", (Object)recordMetadata);
                    }
                    latch.countDown();
                });
                latch.await();
            }
            catch (InterruptedException e3) {
                logger.error("Exception:", (Throwable)e3);
                return NioUtils.toByteBuffer((String)this.getStatus(exchange, SEND_MESSAGE_EXCEPTION, new Object[]{e3.getMessage(), config.isMultitenancy() ? hostId : userId}));
            }
        } else {
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, result.getError()));
        }
        return NioUtils.toByteBuffer((String)this.getStatus(exchange, "SUC10200", new Object[0]));
    }
}

