/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.user.command.handler;

import com.networknt.client.oauth.ClientCredentialsRequest;
import com.networknt.client.oauth.OauthHelper;
import com.networknt.client.oauth.TokenRequest;
import com.networknt.client.oauth.TokenResponse;
import com.networknt.config.Config;
import com.networknt.config.JsonMapper;
import com.networknt.email.EmailSender;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.kafka.common.AvroSerializer;
import com.networknt.kafka.common.EventId;
import com.networknt.monad.Result;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.utility.NioUtils;
import com.networknt.utility.UuidUtil;
import io.undertow.server.HttpServerExchange;
import jakarta.mail.MessagingException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import net.lightapi.portal.HybridQueryClient;
import net.lightapi.portal.PortalConfig;
import net.lightapi.portal.command.HybridCommandStartup;
import net.lightapi.portal.user.PrivateMessageSentEvent;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/user/sendMessage/0.1.0")
public class SendMessage
implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(SendMessage.class);
    private static final PortalConfig config = (PortalConfig)Config.getInstance().getJsonObjectConfig("portal", PortalConfig.class);
    private static final String INCORRECT_TOKEN_TYPE = "ERR11601";
    private static final String SEND_MESSAGE_EXCEPTION = "ERR11605";
    private static final String EMAIL_SENDING_ERROR = "ERR11619";
    AvroSerializer serializer = new AvroSerializer();

    public ByteBuffer handle(HttpServerExchange exchange, Object input) {
        if (logger.isTraceEnabled()) {
            logger.trace("input = " + String.valueOf(input));
        }
        Map map = (Map)input;
        String toUserId = (String)map.get("userId");
        String subject = (String)map.get("subject");
        String content = (String)map.get("content");
        String hostId = (String)map.get("hostId");
        Map auditInfo = (Map)exchange.getAttachment(AttachmentConstants.AUDIT_INFO);
        String fromEmail = (String)auditInfo.get("user_id");
        if (fromEmail == null) {
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, INCORRECT_TOKEN_TYPE, new Object[]{"Authorization Code Token"}));
        }
        Result resultFromUser = HybridQueryClient.getUserByEmail((HttpServerExchange)exchange, (String)fromEmail);
        if (resultFromUser.isFailure()) {
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, resultFromUser.getError()));
        }
        Map fromUserMap = JsonMapper.string2Map((String)((String)resultFromUser.getResult()));
        String fromId = (String)fromUserMap.get("userId");
        ClientCredentialsRequest tokenRequest = new ClientCredentialsRequest();
        Result resultJwt = OauthHelper.getTokenResult((TokenRequest)tokenRequest);
        if (resultJwt.isFailure()) {
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, resultJwt.getError()));
        }
        Result resultId = HybridQueryClient.getUserById((String)toUserId, (String)((TokenResponse)resultJwt.getResult()).getAccessToken());
        if (resultId.isFailure()) {
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, resultId.getError()));
        }
        String toEmail = (String)resultId.getResult();
        Result result = HybridQueryClient.getNonceByUserId((HttpServerExchange)exchange, (String)fromId);
        if (result.isSuccess()) {
            long nonce = Long.parseLong((String)result.getResult());
            EventId eventId = EventId.newBuilder().setId(UuidUtil.getUUID().toString()).setHostId(hostId).setUserId(fromId).setNonce(nonce).setTimestamp(System.currentTimeMillis()).build();
            PrivateMessageSentEvent event = PrivateMessageSentEvent.newBuilder().setEventId(eventId).setHostId(hostId).setFromId(fromId).setToEmail(toEmail).setSubject(subject).setContent(content).build();
            byte[] bytes = this.serializer.serialize((Object)event);
            ProducerRecord record = new ProducerRecord(config.getTopic(), (Object)(config.isMultitenancy() ? hostId : fromId).getBytes(StandardCharsets.UTF_8), (Object)bytes);
            CountDownLatch latch = new CountDownLatch(1);
            try {
                HybridCommandStartup.producer.send(record, (recordMetadata, e) -> {
                    if (Objects.nonNull(e)) {
                        logger.error("Exception occurred while pushing the event", (Throwable)e);
                    } else {
                        logger.info("Event record pushed successfully. Received Record Metadata is {}", (Object)recordMetadata);
                    }
                    latch.countDown();
                });
                latch.await();
            }
            catch (InterruptedException e2) {
                logger.error("Exception:", (Throwable)e2);
                return NioUtils.toByteBuffer((String)this.getStatus(exchange, SEND_MESSAGE_EXCEPTION, new Object[]{e2.getMessage(), config.isMultitenancy() ? hostId : fromId}));
            }
        } else {
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, result.getError()));
        }
        if (config.isSendEmail()) {
            EmailSender sender = new EmailSender();
            try {
                String emailBody = this.getEmailContent();
                sender.sendMail(toEmail, "You have received a private message on Light Portal", emailBody);
                logger.debug("An email has been sent out to " + toEmail);
            }
            catch (MessagingException e3) {
                logger.error("Failed to send email ", (Throwable)e3);
                return NioUtils.toByteBuffer((String)this.getStatus(exchange, EMAIL_SENDING_ERROR, new Object[]{toEmail}));
            }
        }
        return NioUtils.toByteBuffer((String)this.getStatus(exchange, "SUC10200", new Object[0]));
    }

    private String getEmailContent() {
        String hostUrl = config.getResetHost();
        logger.debug("hostUrl = " + hostUrl);
        String template = Config.getInstance().getStringFromFile("private-message-template.html");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("link", hostUrl);
        return EmailSender.replaceTokens((String)template, map);
    }
}

