/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.user.command.handler;

import com.networknt.config.JsonMapper;
import com.networknt.monad.Failure;
import com.networknt.monad.Result;
import com.networknt.monad.Success;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.status.Status;
import io.undertow.server.HttpServerExchange;
import java.util.Map;
import net.lightapi.portal.HybridQueryClient;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/user/updateUserById/0.1.0")
public class UpdateUserById
extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(UpdateUserById.class);

    protected String getCloudEventType() {
        return "UserUpdatedEvent";
    }

    protected Logger getLogger() {
        return logger;
    }

    protected Result<Map<String, Object>> enrichInput(HttpServerExchange exchange, Map<String, Object> map) {
        String userId = (String)map.get("userId");
        Result resultUser = HybridQueryClient.getUserById((HttpServerExchange)exchange, (String)userId);
        if (resultUser.isFailure()) {
            return Failure.of((Status)resultUser.getError());
        }
        Map oldMap = JsonMapper.string2Map((String)((String)resultUser.getResult()));
        String oldCountry = (String)oldMap.get("country");
        String oldProvince = (String)oldMap.get("province");
        String oldCity = (String)oldMap.get("city");
        if (logger.isTraceEnabled()) {
            logger.trace("oldCountry = {} oldProvince = {} oldCity = {}", new Object[]{oldCountry, oldProvince, oldCity});
        }
        map.put("oldCountry", oldCountry);
        map.put("oldProvince", oldProvince);
        map.put("oldCity", oldCity);
        return Success.of(map);
    }
}

