/*
 * Decompiled with CFR 0.152.
 */
package net.luckperms.rest.service;

import java.util.List;
import java.util.Set;
import net.luckperms.rest.model.CreateGroupRequest;
import net.luckperms.rest.model.Group;
import net.luckperms.rest.model.GroupSearchResult;
import net.luckperms.rest.model.Metadata;
import net.luckperms.rest.model.Node;
import net.luckperms.rest.model.NodeType;
import net.luckperms.rest.model.PermissionCheckRequest;
import net.luckperms.rest.model.PermissionCheckResult;
import net.luckperms.rest.model.TemporaryNodeMergeStrategy;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface GroupService {
    @GET(value="/group")
    public Call<Set<String>> list();

    @POST(value="/group")
    public Call<Group> create(@Body CreateGroupRequest var1);

    @GET(value="/group/search")
    public Call<List<GroupSearchResult>> searchNodesByKey(@Query(value="key") String var1);

    @GET(value="/group/search")
    public Call<List<GroupSearchResult>> searchNodesByKeyStartsWith(@Query(value="keyStartsWith") String var1);

    @GET(value="/group/search")
    public Call<List<GroupSearchResult>> searchNodesByMetaKey(@Query(value="metaKey") String var1);

    @GET(value="/group/search")
    public Call<List<GroupSearchResult>> searchNodesByType(@Query(value="type") NodeType var1);

    @GET(value="/group/{name}")
    public Call<Group> get(@Path(value="name") String var1);

    @DELETE(value="/group/{name}")
    public Call<Void> delete(@Path(value="name") String var1);

    @GET(value="/group/{name}/nodes")
    public Call<List<Node>> nodes(@Path(value="name") String var1);

    @POST(value="/group/{name}/nodes")
    public Call<List<Node>> nodesAdd(@Path(value="name") String var1, @Body Node var2);

    @POST(value="/group/{name}/nodes")
    public Call<List<Node>> nodesAdd(@Path(value="name") String var1, @Body Node var2, @Query(value="temporaryNodeMergeStrategy") TemporaryNodeMergeStrategy var3);

    @PATCH(value="/group/{name}/nodes")
    public Call<List<Node>> nodesAdd(@Path(value="name") String var1, @Body List<Node> var2);

    @PATCH(value="/group/{name}/nodes")
    public Call<List<Node>> nodesAdd(@Path(value="name") String var1, @Body List<Node> var2, @Query(value="temporaryNodeMergeStrategy") TemporaryNodeMergeStrategy var3);

    @PUT(value="/group/{name}/nodes")
    public Call<Void> nodesSet(@Path(value="name") String var1, @Body List<Node> var2);

    @DELETE(value="/group/{name}/nodes")
    public Call<Void> nodesDelete(@Path(value="name") String var1);

    @HTTP(method="DELETE", path="/group/{name}/nodes", hasBody=true)
    public Call<Void> nodesDelete(@Path(value="name") String var1, @Body List<Node> var2);

    @GET(value="/group/{name}/meta")
    public Call<Metadata> metadata(@Path(value="name") String var1);

    @GET(value="/group/{name}/permission-check")
    public Call<PermissionCheckResult> permissionCheck(@Path(value="name") String var1, @Query(value="permission") String var2);

    @POST(value="/group/{name}/permission-check")
    public Call<PermissionCheckResult> permissionCheck(@Path(value="name") String var1, @Body PermissionCheckRequest var2);
}

