/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.script;

import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import net.officefloor.frame.api.build.Indexed;
import net.officefloor.frame.api.function.ManagedFunctionContext;
import net.officefloor.frame.api.function.StaticManagedFunction;
import net.officefloor.plugin.clazz.dependency.ClassDependencyFactory;
import net.officefloor.script.ScriptExceptionTranslator;

public class ScriptManagedFunction
extends StaticManagedFunction<Indexed, Indexed> {
    private final ThreadLocal<Invocable> invocable = new ThreadLocal();
    private final ScriptEngineManager engineManager;
    private final String engineName;
    private final ScriptEngineDecorator scriptEngineDecorator;
    private final String setupScript;
    private final String script;
    private final String functionName;
    private final ClassDependencyFactory[] parameterFactories;
    private final ScriptExceptionTranslator scriptExceptionTranslator;

    public ScriptManagedFunction(ScriptEngineManager engineManager, String engineName, ScriptEngineDecorator scriptEngineDecorator, String setupScript, String script, String functionName, ClassDependencyFactory[] parameterFactories, ScriptExceptionTranslator scriptExceptionTranslator) {
        this.engineManager = engineManager;
        this.engineName = engineName;
        this.scriptEngineDecorator = scriptEngineDecorator;
        this.setupScript = setupScript;
        this.script = script;
        this.functionName = functionName;
        this.parameterFactories = parameterFactories;
        this.scriptExceptionTranslator = scriptExceptionTranslator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ManagedFunctionContext<Indexed, Indexed> context) throws Throwable {
        Invocable invocable = this.invocable.get();
        if (invocable == null) {
            ScriptEngineManager scriptEngineManager = this.engineManager;
            synchronized (scriptEngineManager) {
                ScriptEngine engine = this.engineManager.getEngineByName(this.engineName);
                this.scriptEngineDecorator.decorate(engine);
                if (this.setupScript != null) {
                    engine.eval(this.setupScript);
                }
                engine.eval(this.script);
                invocable = (Invocable)((Object)engine);
                this.invocable.set(invocable);
            }
        }
        Object[] arguments = new Object[this.parameterFactories.length];
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = this.parameterFactories[i].createDependency(context);
        }
        try {
            context.setNextFunctionArgument(invocable.invokeFunction(this.functionName, arguments));
        }
        catch (ScriptException ex) {
            Throwable translated = this.scriptExceptionTranslator.translate(ex);
            throw translated != null ? translated : ex;
        }
    }

    @FunctionalInterface
    public static interface ScriptEngineDecorator {
        public void decorate(ScriptEngine var1) throws Exception;
    }
}

