/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.script;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import net.officefloor.activity.procedure.spi.ManagedFunctionProcedureSource;
import net.officefloor.activity.procedure.spi.ProcedureListContext;
import net.officefloor.activity.procedure.spi.ProcedureManagedFunctionContext;
import net.officefloor.activity.procedure.spi.ProcedureSource;
import net.officefloor.activity.procedure.spi.ProcedureSourceServiceFactory;
import net.officefloor.compile.impl.util.CompileUtil;
import net.officefloor.compile.spi.managedfunction.source.ManagedFunctionFlowTypeBuilder;
import net.officefloor.compile.spi.managedfunction.source.ManagedFunctionObjectTypeBuilder;
import net.officefloor.compile.spi.managedfunction.source.ManagedFunctionTypeBuilder;
import net.officefloor.frame.api.build.Indexed;
import net.officefloor.frame.api.function.ManagedFunctionFactory;
import net.officefloor.frame.api.source.ServiceContext;
import net.officefloor.frame.api.source.SourceContext;
import net.officefloor.plugin.clazz.dependency.ClassDependencyFactory;
import net.officefloor.plugin.clazz.dependency.impl.AsynchronousFlowClassDependencyFactory;
import net.officefloor.plugin.clazz.dependency.impl.ObjectClassDependencyFactory;
import net.officefloor.plugin.clazz.dependency.impl.VariableClassDependencyFactory;
import net.officefloor.plugin.section.clazz.ParameterAnnotation;
import net.officefloor.plugin.variable.Var;
import net.officefloor.plugin.variable.VariableAnnotation;
import net.officefloor.plugin.variable.VariableManagedObjectSource;
import net.officefloor.script.ScriptExceptionTranslator;
import net.officefloor.script.ScriptFlowParameterFactory;
import net.officefloor.script.ScriptFunctionMetaData;
import net.officefloor.script.ScriptManagedFunction;
import net.officefloor.script.ScriptParameterMetaData;
import net.officefloor.web.HttpCookieParameterAnnotation;
import net.officefloor.web.HttpHeaderParameterAnnotation;
import net.officefloor.web.HttpObjectAnnotation;
import net.officefloor.web.HttpParametersAnnotation;
import net.officefloor.web.HttpPathParameterAnnotation;
import net.officefloor.web.HttpQueryParameterAnnotation;

public abstract class AbstractScriptProcedureSourceServiceFactory
implements ProcedureSourceServiceFactory {
    protected abstract String getSourceName();

    protected abstract String[] getScriptFileExtensions(SourceContext var1) throws Exception;

    protected abstract String getScriptEngineName(SourceContext var1) throws Exception;

    protected void decorateScriptEngine(ScriptEngine engine, SourceContext context) throws Exception {
    }

    protected String getSetupScriptPath(SourceContext context) throws Exception {
        return null;
    }

    protected abstract String getMetaDataScriptPath(SourceContext var1) throws Exception;

    protected ScriptExceptionTranslator getScriptExceptionTranslator() {
        return null;
    }

    protected String loadSetupScript(SourceContext sourceContext) throws Exception {
        String setupScriptPath = this.getSetupScriptPath(sourceContext);
        String setupScript = null;
        if (setupScriptPath != null) {
            setupScript = AbstractScriptProcedureSourceServiceFactory.readContent(sourceContext.getResource(setupScriptPath));
        }
        return setupScript;
    }

    protected String loadResourceScript(String resource, SourceContext sourceContext) throws Exception {
        return AbstractScriptProcedureSourceServiceFactory.readContent(sourceContext.getResource(resource));
    }

    protected Invocable loadScriptEngine(ScriptEngineManager engineManager, String engineName, String setupScript, String script, String metaDataScript, SourceContext sourceContext) throws Exception {
        ScriptEngine engine = engineManager.getEngineByName(engineName);
        this.decorateScriptEngine(engine, sourceContext);
        if (!(engine instanceof Invocable)) {
            throw new IllegalStateException("Script engine " + engineName + " must be " + Invocable.class.getSimpleName());
        }
        Invocable invocable = (Invocable)((Object)engine);
        if (setupScript != null) {
            engine.eval(setupScript);
        }
        engine.eval(script);
        if (metaDataScript != null) {
            engine.eval(metaDataScript);
        }
        return invocable;
    }

    protected void listProcedures(ProcedureListContext context) throws Exception {
        String resource = context.getResource();
        boolean isScriptResource = false;
        String[] extensions = this.getScriptFileExtensions(context.getSourceContext());
        if (extensions != null) {
            for (String extension : extensions) {
                String compareExtension;
                if (CompileUtil.isBlank((String)extension)) continue;
                String string = compareExtension = extension.startsWith(".") ? extension : "." + extension;
                if (!resource.toLowerCase().endsWith(compareExtension.toLowerCase())) continue;
                isScriptResource = true;
            }
        }
        if (isScriptResource) {
            context.addProcedure(null);
        }
    }

    protected void loadManagedFunction(ProcedureManagedFunctionContext context) throws Exception {
        ScriptExceptionTranslator scriptExceptionTranslator;
        String resource = context.getResource();
        String procedureName = context.getProcedureName();
        SourceContext sourceContext = context.getSourceContext();
        ScriptEngineManager engineManager = new ScriptEngineManager(sourceContext.getClassLoader());
        String engineName = this.getScriptEngineName(sourceContext);
        String setupScript = this.loadSetupScript(sourceContext);
        String script = this.loadResourceScript(resource, sourceContext);
        String metaDataScriptPath = this.getMetaDataScriptPath(sourceContext);
        String metaDataScript = AbstractScriptProcedureSourceServiceFactory.readContent(sourceContext.getResource(metaDataScriptPath));
        Invocable invocable = this.loadScriptEngine(engineManager, engineName, setupScript, script, metaDataScript = metaDataScript.replace("_FUNCTION_NAME_", procedureName), sourceContext);
        Object metaData = invocable.invokeFunction("OFFICEFLOOR_METADATA_" + procedureName, new Object[0]);
        if (metaData == null) {
            throw new Exception("No meta-data provided for " + procedureName);
        }
        if (!(metaData instanceof String)) {
            throw new Exception("Meta-data provided for " + procedureName + " must be JSON string (" + metaData.getClass().getName() + ")");
        }
        String metaDataJsonString = (String)metaData;
        ScriptFunctionMetaData functionMetaData = (ScriptFunctionMetaData)new ObjectMapper().readValue(metaDataJsonString, ScriptFunctionMetaData.class);
        String error = functionMetaData.getError();
        if (!CompileUtil.isBlank((String)error)) {
            throw new Exception(error);
        }
        Function<String, String> translateClass = className -> {
            switch (className) {
                case "boolean": {
                    return Boolean.class.getName();
                }
                case "byte": {
                    return Byte.class.getName();
                }
                case "short": {
                    return Short.class.getName();
                }
                case "char": {
                    return Character.class.getName();
                }
                case "int": {
                    return Integer.class.getName();
                }
                case "long": {
                    return Long.class.getName();
                }
                case "float": {
                    return Float.class.getName();
                }
                case "double": {
                    return Double.class.getName();
                }
            }
            return className;
        };
        Function<String, Class> loadClass = className -> sourceContext.loadClass((String)translateClass.apply((String)className));
        List<ScriptParameterMetaData> parameterMetaDatas = functionMetaData.getParameters();
        if (parameterMetaDatas == null) {
            parameterMetaDatas = Collections.emptyList();
        }
        if ((scriptExceptionTranslator = this.getScriptExceptionTranslator()) == null) {
            scriptExceptionTranslator = ex -> ex;
        }
        ScriptManagedFunction.ScriptEngineDecorator scriptEngineDecorator = engineToDecorate -> this.decorateScriptEngine(engineToDecorate, sourceContext);
        ClassDependencyFactory[] parameterFactories = new ClassDependencyFactory[parameterMetaDatas.size()];
        ManagedFunctionTypeBuilder function = context.setManagedFunction((ManagedFunctionFactory)new ScriptManagedFunction(engineManager, engineName, scriptEngineDecorator, setupScript, script, procedureName, parameterFactories, scriptExceptionTranslator), Indexed.class, Indexed.class);
        int objectIndex = 0;
        int flowIndex = 0;
        for (int i = 0; i < parameterMetaDatas.size(); ++i) {
            boolean isVariable;
            ManagedFunctionObjectTypeBuilder parameter;
            Class<?> type;
            ScriptParameterMetaData parameterMetaData = parameterMetaDatas.get(i);
            String parameterName = parameterMetaData.getName();
            String qualifier = parameterMetaData.getQualifier();
            String typeName = parameterMetaData.getType();
            String arraySuffix = "[]";
            if (CompileUtil.isBlank((String)typeName)) {
                type = null;
            } else if (typeName.endsWith("[]")) {
                String componentTypeName = typeName.substring(0, typeName.length() - "[]".length());
                Class componentType = sourceContext.loadClass(componentTypeName);
                type = Array.newInstance(componentType, 0).getClass();
            } else {
                type = loadClass.apply(typeName);
            }
            int parameterIndex = i;
            Runnable ensureHaveType = () -> {
                if (type == null) {
                    throw new IllegalStateException("Must provide type for parameter " + parameterIndex + " (with nature " + parameterMetaData.getNature() + ")");
                }
            };
            Runnable ensureHaveName = () -> {
                if (CompileUtil.isBlank((String)parameterName)) {
                    throw new IllegalStateException("Must provide name for parameter " + parameterIndex + " (with nature " + parameterMetaData.getNature() + ")");
                }
            };
            String nature = parameterMetaData.getNature();
            if (nature == null) {
                nature = "object";
            }
            switch (nature) {
                case "object": 
                case "parameter": {
                    ensureHaveType.run();
                    parameterFactories[i] = new ObjectClassDependencyFactory(objectIndex++);
                    parameter = function.addObject(type);
                    if (qualifier != null) {
                        parameter.setLabel(qualifier + "-" + type.getName());
                        parameter.setTypeQualifier(qualifier);
                    } else {
                        parameter.setLabel(type.getName());
                    }
                    if ("parameter".equals(nature)) {
                        parameter.addAnnotation((Object)new ParameterAnnotation());
                    }
                    isVariable = false;
                    break;
                }
                case "val": {
                    ensureHaveType.run();
                    parameterFactories[i] = new VariableClassDependencyFactory(objectIndex++, VariableManagedObjectSource::val);
                    isVariable = true;
                    break;
                }
                case "in": {
                    ensureHaveType.run();
                    parameterFactories[i] = new VariableClassDependencyFactory(objectIndex++, VariableManagedObjectSource::in);
                    isVariable = true;
                    break;
                }
                case "out": {
                    ensureHaveType.run();
                    parameterFactories[i] = new VariableClassDependencyFactory(objectIndex++, VariableManagedObjectSource::out);
                    isVariable = true;
                    break;
                }
                case "var": {
                    ensureHaveType.run();
                    parameterFactories[i] = new VariableClassDependencyFactory(objectIndex++, VariableManagedObjectSource::var);
                    isVariable = true;
                    break;
                }
                case "httpPathParameter": {
                    ensureHaveName.run();
                    parameterFactories[i] = new ObjectClassDependencyFactory(objectIndex++);
                    parameter = function.addObject(String.class);
                    HttpPathParameterAnnotation httpPathParameter = new HttpPathParameterAnnotation(parameterName);
                    parameter.addAnnotation((Object)httpPathParameter);
                    parameter.setTypeQualifier(httpPathParameter.getQualifier());
                    isVariable = false;
                    break;
                }
                case "httpQueryParameter": {
                    ensureHaveName.run();
                    parameterFactories[i] = new ObjectClassDependencyFactory(objectIndex++);
                    parameter = function.addObject(String.class);
                    HttpQueryParameterAnnotation httpQueryParameter = new HttpQueryParameterAnnotation(parameterName);
                    parameter.addAnnotation((Object)httpQueryParameter);
                    parameter.setTypeQualifier(httpQueryParameter.getQualifier());
                    isVariable = false;
                    break;
                }
                case "httpHeaderParameter": {
                    ensureHaveName.run();
                    parameterFactories[i] = new ObjectClassDependencyFactory(objectIndex++);
                    parameter = function.addObject(String.class);
                    HttpHeaderParameterAnnotation httpHeaderParameter = new HttpHeaderParameterAnnotation(parameterName);
                    parameter.addAnnotation((Object)httpHeaderParameter);
                    parameter.setTypeQualifier(httpHeaderParameter.getQualifier());
                    isVariable = false;
                    break;
                }
                case "httpCookieParameter": {
                    ensureHaveName.run();
                    parameterFactories[i] = new ObjectClassDependencyFactory(objectIndex++);
                    parameter = function.addObject(String.class);
                    HttpCookieParameterAnnotation httpCookieParameter = new HttpCookieParameterAnnotation(parameterName);
                    parameter.addAnnotation((Object)httpCookieParameter);
                    parameter.setTypeQualifier(httpCookieParameter.getQualifier());
                    isVariable = false;
                    break;
                }
                case "httpParameters": {
                    ensureHaveType.run();
                    parameterFactories[i] = new ObjectClassDependencyFactory(objectIndex++);
                    parameter = function.addObject(type);
                    parameter.addAnnotation((Object)new HttpParametersAnnotation());
                    if (qualifier != null) {
                        parameter.setTypeQualifier(qualifier);
                    }
                    isVariable = false;
                    break;
                }
                case "httpObject": {
                    ensureHaveType.run();
                    parameterFactories[i] = new ObjectClassDependencyFactory(objectIndex++);
                    parameter = function.addObject(type);
                    parameter.addAnnotation((Object)new HttpObjectAnnotation(new String[0]));
                    if (qualifier != null) {
                        parameter.setTypeQualifier(qualifier);
                    }
                    isVariable = false;
                    break;
                }
                case "flow": {
                    ensureHaveName.run();
                    ManagedFunctionFlowTypeBuilder flow = function.addFlow();
                    flow.setLabel(parameterName);
                    if (type != null) {
                        flow.setArgumentType(type);
                    }
                    parameterFactories[i] = new ScriptFlowParameterFactory(flowIndex++);
                    isVariable = false;
                    break;
                }
                case "asynchronousFlow": {
                    parameterFactories[i] = new AsynchronousFlowClassDependencyFactory();
                    isVariable = false;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown nature " + nature + " for parameter " + i + " (" + (qualifier == null ? "" : "qualifier=" + qualifier + ", ") + "type=" + typeName + ")");
                }
            }
            if (!isVariable) continue;
            String validTypeName = VariableManagedObjectSource.type((String)typeName);
            String variableName = VariableManagedObjectSource.name((String)qualifier, (String)validTypeName);
            parameter = function.addObject(Var.class);
            parameter.setTypeQualifier(variableName);
            parameter.addAnnotation((Object)new VariableAnnotation(variableName, validTypeName));
        }
        String nextArgumentType = functionMetaData.getNextArgumentType();
        if (nextArgumentType != null) {
            Class argumentType = nextArgumentType == null ? null : sourceContext.loadClass(nextArgumentType);
            function.setReturnType(argumentType);
        }
    }

    private static String readContent(InputStream content) throws IOException {
        StringWriter buffer = new StringWriter();
        try (InputStreamReader reader = new InputStreamReader(content);){
            int character = ((Reader)reader).read();
            while (character != -1) {
                buffer.write(character);
                character = ((Reader)reader).read();
            }
        }
        return buffer.toString();
    }

    public ProcedureSource createService(ServiceContext context) throws Throwable {
        return new ScriptProcedureSource();
    }

    private class ScriptProcedureSource
    implements ManagedFunctionProcedureSource {
        private ScriptProcedureSource() {
        }

        public String getSourceName() {
            return AbstractScriptProcedureSourceServiceFactory.this.getSourceName();
        }

        public void listProcedures(ProcedureListContext context) throws Exception {
            AbstractScriptProcedureSourceServiceFactory.this.listProcedures(context);
        }

        public void loadManagedFunction(ProcedureManagedFunctionContext context) throws Exception {
            AbstractScriptProcedureSourceServiceFactory.this.loadManagedFunction(context);
        }
    }
}

