/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.tutorial.databasehttpserver;

import java.sql.Connection;
import java.sql.DriverManager;
import javax.sql.DataSource;
import net.officefloor.plugin.autowire.AutoWireObject;
import net.officefloor.plugin.autowire.AutoWireOfficeFloorSource;
import net.officefloor.plugin.jdbc.datasource.DataSourceManagedObjectSource;
import net.officefloor.plugin.web.http.parameters.source.HttpParametersObjectManagedObjectSource;
import net.officefloor.plugin.web.http.server.HttpServerAutoWireOfficeFloorSource;
import net.officefloor.tutorial.databasehttpserver.Row;
import net.officefloor.tutorial.databasehttpserver.Template;
import org.hsqldb.jdbcDriver;

public class DatabaseHttpServer {
    public static void main(String[] args) throws Exception {
        DatabaseHttpServer.createDatabase();
        HttpServerAutoWireOfficeFloorSource source = new HttpServerAutoWireOfficeFloorSource();
        HttpParametersObjectManagedObjectSource.autoWire((AutoWireOfficeFloorSource)source, Row.class);
        source.addHttpTemplate("Template.ofp", Template.class, "example");
        AutoWireObject object = source.addManagedObject(DataSourceManagedObjectSource.class, null, new Class[]{DataSource.class});
        object.loadProperties("datasource.properties");
        source.openOfficeFloor();
    }

    private static void createDatabase() throws Exception {
        Class.forName(jdbcDriver.class.getName());
        Connection connection = DriverManager.getConnection("jdbc:hsqldb:mem:exampleDb", "sa", "");
        connection.createStatement().execute("CREATE TABLE EXAMPLE ( ID IDENTITY PRIMARY KEY, NAME VARCHAR(20), DESCRIPTION VARCHAR(256) )");
        connection.createStatement().execute("INSERT INTO EXAMPLE ( NAME, DESCRIPTION ) VALUES ( 'TEST', 'TEST' )");
    }
}

