/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.tutorial.databasehttpserver;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import net.officefloor.tutorial.databasehttpserver.Row;
import net.officefloor.web.HttpParameters;

public class Template {
    public Row[] getRows(Connection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("SELECT * FROM EXAMPLE ORDER BY ID");){
            ResultSet resultSet = statement.executeQuery();
            LinkedList<Row> rows = new LinkedList<Row>();
            while (resultSet.next()) {
                rows.add(new Row(resultSet.getInt("ID"), resultSet.getString("NAME"), resultSet.getString("DESCRIPTION")));
            }
            Row[] rowArray = rows.toArray(new Row[rows.size()]);
            return rowArray;
        }
    }

    public void addRow(Row row, Connection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("INSERT INTO EXAMPLE (NAME, DESCRIPTION) VALUES ( ?, ? )");){
            statement.setString(1, row.getName());
            statement.setString(2, row.getDescription());
            statement.executeUpdate();
        }
    }

    public void deleteRow(DeleteRow delete, Connection connection) throws SQLException {
        int id = Integer.parseInt(delete.id);
        try (PreparedStatement statement = connection.prepareStatement("DELETE FROM EXAMPLE WHERE ID = ?");){
            statement.setInt(1, id);
            statement.executeUpdate();
        }
    }

    @HttpParameters
    public static class DeleteRow
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String id;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DeleteRow)) {
                return false;
            }
            DeleteRow other = (DeleteRow)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            return !(this$id == null ? other$id != null : !this$id.equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DeleteRow;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            return result;
        }

        public String toString() {
            return "Template.DeleteRow(id=" + this.getId() + ")";
        }
    }
}

