/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.tutorial.jwtresourcehttpserver;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.security.Keys;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import net.officefloor.web.jwt.jwks.JwksRetriever;

public class MockJwksRetriever
implements JwksRetriever {
    private static ObjectMapper mapper = new ObjectMapper();

    public InputStream retrieveJwks() throws Exception {
        RSAPublicKey key = (RSAPublicKey)Keys.keyPairFor((SignatureAlgorithm)SignatureAlgorithm.RS256).getPublic();
        JwksKeys keys = new JwksKeys(Arrays.asList(new JwksKey("RSA", MockJwksRetriever.base64(key.getModulus()), MockJwksRetriever.base64(key.getPublicExponent()), 0L, Long.MAX_VALUE)));
        String content = mapper.writeValueAsString((Object)keys);
        return new ByteArrayInputStream(content.getBytes());
    }

    private static String base64(BigInteger value) {
        return Base64.getUrlEncoder().encodeToString(value.toByteArray());
    }

    public static class JwksKey {
        private final String kty;
        private final String n;
        private final String e;
        private final long nbf;
        private final long exp;

        public JwksKey(String kty, String n, String e, long nbf, long exp) {
            this.kty = kty;
            this.n = n;
            this.e = e;
            this.nbf = nbf;
            this.exp = exp;
        }

        public String getKty() {
            return this.kty;
        }

        public String getN() {
            return this.n;
        }

        public String getE() {
            return this.e;
        }

        public long getNbf() {
            return this.nbf;
        }

        public long getExp() {
            return this.exp;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JwksKey)) {
                return false;
            }
            JwksKey other = (JwksKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$kty = this.getKty();
            String other$kty = other.getKty();
            if (this$kty == null ? other$kty != null : !this$kty.equals(other$kty)) {
                return false;
            }
            String this$n = this.getN();
            String other$n = other.getN();
            if (this$n == null ? other$n != null : !this$n.equals(other$n)) {
                return false;
            }
            String this$e = this.getE();
            String other$e = other.getE();
            if (this$e == null ? other$e != null : !this$e.equals(other$e)) {
                return false;
            }
            if (this.getNbf() != other.getNbf()) {
                return false;
            }
            return this.getExp() == other.getExp();
        }

        protected boolean canEqual(Object other) {
            return other instanceof JwksKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $kty = this.getKty();
            result = result * 59 + ($kty == null ? 43 : $kty.hashCode());
            String $n = this.getN();
            result = result * 59 + ($n == null ? 43 : $n.hashCode());
            String $e = this.getE();
            result = result * 59 + ($e == null ? 43 : $e.hashCode());
            long $nbf = this.getNbf();
            result = result * 59 + (int)($nbf >>> 32 ^ $nbf);
            long $exp = this.getExp();
            result = result * 59 + (int)($exp >>> 32 ^ $exp);
            return result;
        }

        public String toString() {
            return "MockJwksRetriever.JwksKey(kty=" + this.getKty() + ", n=" + this.getN() + ", e=" + this.getE() + ", nbf=" + this.getNbf() + ", exp=" + this.getExp() + ")";
        }
    }

    public static class JwksKeys {
        private final List<JwksKey> keys;

        public JwksKeys(List<JwksKey> keys) {
            this.keys = keys;
        }

        public List<JwksKey> getKeys() {
            return this.keys;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JwksKeys)) {
                return false;
            }
            JwksKeys other = (JwksKeys)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<JwksKey> this$keys = this.getKeys();
            List<JwksKey> other$keys = other.getKeys();
            return !(this$keys == null ? other$keys != null : !((Object)this$keys).equals(other$keys));
        }

        protected boolean canEqual(Object other) {
            return other instanceof JwksKeys;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<JwksKey> $keys = this.getKeys();
            result = result * 59 + ($keys == null ? 43 : ((Object)$keys).hashCode());
            return result;
        }

        public String toString() {
            return "MockJwksRetriever.JwksKeys(keys=" + this.getKeys() + ")";
        }
    }
}

