/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.tutorial.teamhttpserver;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import net.officefloor.plugin.section.clazz.NextTask;
import net.officefloor.plugin.section.clazz.Parameter;
import net.officefloor.plugin.web.http.application.HttpSessionStateful;
import net.officefloor.tutorial.teamhttpserver.EncryptLetter;
import net.officefloor.tutorial.teamhttpserver.LetterEncryption;
import net.officefloor.tutorial.teamhttpserver.Template;

@HttpSessionStateful
public class Template
implements Serializable {
    private Map<Character, LetterEncryption> cache = new HashMap();
    private LetterEncryption displayCode;
    private String cacheThreadName;
    private String databaseThreadName;

    public LetterEncryption getTemplate() {
        return this.displayCode;
    }

    public Template getThreadNames() {
        return this;
    }

    public String getCacheThreadName() {
        return this.cacheThreadName;
    }

    public String getDatabaseThreadName() {
        return this.databaseThreadName;
    }

    @NextTask(value="setDisplayCode")
    public LetterEncryption encrypt(EncryptLetter request, PageFlows flows) {
        this.cacheThreadName = Thread.currentThread().getName();
        this.databaseThreadName = "[cached]";
        char letter = request.getLetter();
        LetterEncryption code = (LetterEncryption)this.cache.get(new Character(letter));
        if (code != null) {
            return code;
        }
        flows.retrieveFromDatabase(letter);
        return null;
    }

    public void setDisplayCode(@Parameter LetterEncryption encryption) {
        this.displayCode = encryption;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NextTask(value="setDisplayCode")
    public LetterEncryption retrieveFromDatabase(@Parameter char letter, DataSource dataSource) throws SQLException {
        this.databaseThreadName = Thread.currentThread().getName();
        Connection connection = dataSource.getConnection();
        try {
            PreparedStatement statement = connection.prepareStatement("SELECT CODE FROM LETTER_CODE WHERE LETTER = ?");
            statement.setString(1, String.valueOf(letter));
            ResultSet resultSet = statement.executeQuery();
            resultSet.next();
            String code = resultSet.getString("CODE");
            LetterEncryption letterCode = new LetterEncryption(letter, code.charAt(0));
            this.cache.put(new Character(letter), letterCode);
            LetterEncryption letterEncryption = letterCode;
            return letterEncryption;
        }
        finally {
            connection.close();
        }
    }

    public void handleException(@Parameter SQLException ex) throws Throwable {
        ex.printStackTrace();
        throw ex;
    }
}

