/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.paapi5.v1.auth;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SignHelper {
    private String awsAccessKey;
    private String awsSecretKey;
    private String path;
    private String region;
    private String service;
    private String httpMethodName;
    private Map<String, String> headers;
    private String payload;
    private final String hmacAlgorithm = "AWS4-HMAC-SHA256";
    private final String aws4Request = "aws4_request";
    private String signedHeaders;
    private String xAmzDate;
    private String currentDate;
    private final char[] hexArray = "0123456789ABCDEF".toCharArray();

    private SignHelper() {
    }

    private SignHelper(Builder builder) {
        this.awsAccessKey = builder.accessKey;
        this.awsSecretKey = builder.secretKey;
        this.path = builder.path;
        this.region = builder.region;
        this.service = builder.service;
        this.httpMethodName = builder.httpMethodName;
        this.headers = builder.headers;
        this.payload = builder.payload;
        this.xAmzDate = this.getTimeStamp();
        this.currentDate = this.getDate();
    }

    public Map<String, String> getHeaders() {
        this.headers.put("x-amz-date", this.xAmzDate);
        String canonicalURL = this.prepareCanonicalRequest();
        String stringToSign = this.prepareStringToSign(canonicalURL);
        String signature = this.calculateSignature(stringToSign);
        if (signature != null) {
            this.headers.put("Authorization", this.buildAuthorizationString(signature));
            return this.headers;
        }
        return null;
    }

    private String prepareCanonicalRequest() {
        StringBuilder canonicalUrl = new StringBuilder();
        canonicalUrl.append(this.httpMethodName).append("\n");
        canonicalUrl.append(this.path).append("\n").append("\n");
        StringBuilder signedHeaderBuilder = new StringBuilder();
        if (this.headers != null && !this.headers.isEmpty()) {
            for (Map.Entry<String, String> entrySet : this.headers.entrySet()) {
                String key = entrySet.getKey();
                String value = entrySet.getValue();
                signedHeaderBuilder.append(key).append(";");
                canonicalUrl.append(key).append(":").append(value).append("\n");
            }
            canonicalUrl.append("\n");
        } else {
            canonicalUrl.append("\n");
        }
        this.signedHeaders = signedHeaderBuilder.substring(0, signedHeaderBuilder.length() - 1);
        canonicalUrl.append(this.signedHeaders).append("\n");
        this.payload = this.payload == null ? "" : this.payload;
        canonicalUrl.append(this.toHex(this.payload));
        return canonicalUrl.toString();
    }

    private String prepareStringToSign(String canonicalUrl) {
        String stringToSign = "";
        stringToSign = "AWS4-HMAC-SHA256\n";
        stringToSign = stringToSign + this.xAmzDate + "\n";
        stringToSign = stringToSign + this.currentDate + "/" + this.region + "/" + this.service + "/" + "aws4_request" + "\n";
        stringToSign = stringToSign + this.toHex(canonicalUrl);
        return stringToSign;
    }

    private String calculateSignature(String stringToSign) {
        try {
            byte[] signatureKey = this.getSignatureKey(this.awsSecretKey, this.currentDate, this.region, this.service);
            byte[] signature = this.hmacSha256(signatureKey, stringToSign);
            return this.bytesToHex(signature);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private String buildAuthorizationString(String signature) {
        return "AWS4-HMAC-SHA256 Credential=" + this.awsAccessKey + "/" + this.getDate() + "/" + this.region + "/" + this.service + "/" + "aws4_request" + ",SignedHeaders=" + this.signedHeaders + ",Signature=" + signature;
    }

    private String toHex(String data) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(data.getBytes("UTF-8"));
            byte[] digest = messageDigest.digest();
            return String.format("%064x", new BigInteger(1, digest));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return null;
    }

    private byte[] hmacSha256(byte[] key, String data) throws Exception {
        String algorithm = "HmacSHA256";
        Mac mac = Mac.getInstance(algorithm);
        mac.init(new SecretKeySpec(key, algorithm));
        return mac.doFinal(data.getBytes("UTF8"));
    }

    private byte[] getSignatureKey(String key, String date, String regionName, String serviceName) throws Exception {
        byte[] kSecret = ("AWS4" + key).getBytes("UTF8");
        byte[] kDate = this.hmacSha256(kSecret, date);
        byte[] kRegion = this.hmacSha256(kDate, regionName);
        byte[] kService = this.hmacSha256(kRegion, serviceName);
        byte[] kSigning = this.hmacSha256(kService, "aws4_request");
        return kSigning;
    }

    private String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = this.hexArray[v >>> 4];
            hexChars[j * 2 + 1] = this.hexArray[v & 0xF];
        }
        return new String(hexChars).toLowerCase();
    }

    private String getTimeStamp() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(new Date());
    }

    private String getDate() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(new Date());
    }

    public static class Builder {
        private String accessKey;
        private String secretKey;
        private String path;
        private String region;
        private String service;
        private String httpMethodName;
        private Map<String, String> headers;
        private String payload;

        public Builder(String accessKey, String secretKey) {
            this.accessKey = accessKey;
            this.secretKey = secretKey;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder region(String region) {
            this.region = region;
            return this;
        }

        public Builder service(String service) {
            this.service = service;
            return this;
        }

        public Builder httpMethodName(String httpMethodName) {
            this.httpMethodName = httpMethodName;
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder payload(String payload) {
            this.payload = payload;
            return this;
        }

        public SignHelper build() {
            return new SignHelper(this);
        }
    }
}

