/*
 * Decompiled with CFR 0.152.
 */
package samples;

import com.amazon.paapi5.v1.ApiClient;
import com.amazon.paapi5.v1.ApiException;
import com.amazon.paapi5.v1.ErrorData;
import com.amazon.paapi5.v1.GetVariationsRequest;
import com.amazon.paapi5.v1.GetVariationsResource;
import com.amazon.paapi5.v1.GetVariationsResponse;
import com.amazon.paapi5.v1.Item;
import com.amazon.paapi5.v1.PartnerType;
import com.amazon.paapi5.v1.api.DefaultApi;
import java.util.ArrayList;

public class SampleGetVariationsApi {
    public static void main(String[] args) {
        ApiClient client = new ApiClient();
        client.setAccessKey("<YOUR-ACCESS-KEY-HERE>");
        client.setSecretKey("<YOUR-SECRET-KEY-HERE>");
        String partnerTag = "<YOUR-PARTNER-TAG-HERE>";
        client.setHost("webservices.amazon.com");
        client.setRegion("us-east-1");
        DefaultApi api = new DefaultApi(client);
        ArrayList<GetVariationsResource> getVariationsResources = new ArrayList<GetVariationsResource>();
        getVariationsResources.add(GetVariationsResource.ITEMINFO_TITLE);
        getVariationsResources.add(GetVariationsResource.OFFERS_LISTINGS_PRICE);
        String asin = "B07H65KP63";
        GetVariationsRequest getVariationsRequest = new GetVariationsRequest().ASIN(asin).partnerTag(partnerTag).resources(getVariationsResources).partnerType(PartnerType.ASSOCIATES);
        try {
            GetVariationsResponse response = api.getVariations(getVariationsRequest);
            System.out.println("API called successfully");
            System.out.println("Complete response: " + response);
            if (response.getVariationsResult() != null) {
                System.out.println("Printing VariationSummary: ");
                if (response.getVariationsResult().getVariationSummary() != null && response.getVariationsResult().getVariationSummary().getVariationCount() != null) {
                    System.out.println("VariationCount: " + response.getVariationsResult().getVariationSummary().getVariationCount());
                }
                System.out.println("Printing first item information in VariationsResult:");
                Item item = response.getVariationsResult().getItems().get(0);
                if (item != null) {
                    if (item.getASIN() != null) {
                        System.out.println("ASIN: " + item.getASIN());
                    }
                    if (item.getDetailPageURL() != null) {
                        System.out.println("DetailPageURL: " + item.getDetailPageURL());
                    }
                    if (item.getItemInfo() != null && item.getItemInfo().getTitle() != null && item.getItemInfo().getTitle().getDisplayValue() != null) {
                        System.out.println("Title: " + item.getItemInfo().getTitle().getDisplayValue());
                    }
                    if (item.getOffers() != null && item.getOffers().getListings() != null && item.getOffers().getListings().get(0).getPrice() != null && item.getOffers().getListings().get(0).getPrice().getDisplayAmount() != null) {
                        System.out.println("Buying price: " + item.getOffers().getListings().get(0).getPrice().getDisplayAmount());
                    }
                }
            }
            if (response.getErrors() != null) {
                System.out.println("Printing errors:\nPrinting Errors from list of Errors");
                for (ErrorData error : response.getErrors()) {
                    System.out.println("Error code: " + error.getCode());
                    System.out.println("Error message: " + error.getMessage());
                }
            }
        }
        catch (ApiException exception) {
            System.out.println("Error calling PA-API 5.0!");
            System.out.println("Status code: " + exception.getCode());
            System.out.println("Errors: " + exception.getResponseBody());
            System.out.println("Message: " + exception.getMessage());
            if (exception.getResponseHeaders() != null) {
                System.out.println("Request ID: " + exception.getResponseHeaders().get("x-amzn-RequestId"));
            }
        }
        catch (Exception exception) {
            System.out.println("Exception message: " + exception.getMessage());
        }
    }
}

