/*
 * Decompiled with CFR 0.152.
 */
package net.plsar;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Scanner;
import java.util.logging.Logger;
import net.plsar.ExecutableDatasource;
import net.plsar.PersistenceConfig;
import net.plsar.SchemaConfig;
import org.h2.tools.RunScript;

public class DatabaseEnvironmentManager {
    Logger Log = Logger.getLogger(DatabaseEnvironmentManager.class.getName());

    public void configure(SchemaConfig schemaConfig, PersistenceConfig persistenceConfig) {
        try {
            Path schemaFilePath = Paths.get("src", "main", "resources", schemaConfig.getSchema());
            File schemaConfigFile = new File(schemaFilePath.toAbsolutePath().toString());
            if (!schemaConfigFile.exists()) {
                this.Log.info("non-persistence mode");
                this.Log.info("schema.sql missing in src/main/resources/. project will be treated as a non persistent application.");
                this.Log.info("database environment setup complete");
                return;
            }
            FileInputStream in = new FileInputStream(schemaConfigFile);
            if (in == null || ((InputStream)in).available() == 0) {
                this.Log.info("src/main/resources/{schema}.sql contains no tables. project will be treated as a non persistent application.");
                this.Log.info("database environment setup complete");
                return;
            }
            StringBuilder schemaSql = new StringBuilder();
            if (((InputStream)in).available() > 0) {
                Scanner scanner = new Scanner(in);
                do {
                    schemaSql.append(scanner.nextLine() + "\n");
                } while (scanner.hasNext());
                ((InputStream)in).close();
            }
            ExecutableDatasource datasource = new ExecutableDatasource.Builder().url(persistenceConfig.getUrl()).driver(persistenceConfig.getDriver()).user(persistenceConfig.getUser()).password(persistenceConfig.getPassword()).create();
            Connection conn = datasource.getConnection();
            RunScript.execute(conn, new StringReader("drop all objects;"));
            if (!schemaSql.toString().equals("")) {
                RunScript.execute(conn, new StringReader(schemaSql.toString()));
            }
            conn.commit();
            conn.close();
            this.Log.info("database environment setup complete");
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
    }
}

