/*
 * Decompiled with CFR 0.152.
 */
package net.plsar.model;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.plsar.RouteAttributes;
import net.plsar.model.NetworkSession;
import net.plsar.model.RequestComponent;
import net.plsar.resources.ServerResources;

public class NetworkRequest {
    String uriPath;
    String verb;
    String requestBody;
    NetworkSession networkSession;
    Map<String, String> headers;
    ServerResources serverResources;
    Map<String, RequestComponent> requestComponents;
    RouteAttributes routeAttributes;

    public NetworkRequest(String verb, String uriPath, ServerResources serverResources) {
        this.uriPath = uriPath;
        this.verb = verb;
        this.headers = new HashMap<String, String>();
        this.requestComponents = new HashMap<String, RequestComponent>();
        this.serverResources = serverResources;
    }

    public String getUriPath() {
        return this.uriPath;
    }

    public void setUriPath(String uriPath) {
        this.uriPath = uriPath;
    }

    public void addHeader(String fieldKey, String headerValue) {
        this.headers.put(fieldKey, headerValue);
    }

    public void removeHeader(String fieldKey) {
        this.headers.remove(fieldKey);
    }

    public String getVerb() {
        return this.verb.toLowerCase();
    }

    public void setVerb(String verb) {
        this.verb = verb;
    }

    public String getHeader(String fieldKey) {
        if (this.headers.containsKey(fieldKey)) {
            return this.headers.get(fieldKey);
        }
        return null;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void put(String elementName, RequestComponent requestComponent) {
        this.requestComponents.put(elementName, requestComponent);
    }

    public NetworkSession getSession(boolean existingSession) {
        if (!existingSession) {
            Long time = this.serverResources.getTime(0);
            this.networkSession = new NetworkSession(time, this.serverResources);
        }
        return this.networkSession;
    }

    public void setSession(NetworkSession networkSession) {
        this.networkSession = networkSession;
    }

    public void setRequestComponent(String key, RequestComponent requestComponent) {
        this.requestComponents.put(key, requestComponent);
    }

    public String getValue(String key) {
        if (this.requestComponents.containsKey(key)) {
            return this.requestComponents.get(key).getValue();
        }
        return null;
    }

    public RequestComponent getRequestComponent(String key) {
        if (this.requestComponents.containsKey(key)) {
            return this.requestComponents.get(key);
        }
        return null;
    }

    public List<RequestComponent> getRequestComponents() {
        ArrayList<RequestComponent> components = new ArrayList<RequestComponent>();
        for (Map.Entry<String, RequestComponent> requestComponentEntry : this.requestComponents.entrySet()) {
            components.add(requestComponentEntry.getValue());
        }
        return components;
    }

    public RouteAttributes getRouteAttributes() {
        return this.routeAttributes;
    }

    public void setRouteAttributes(RouteAttributes routeAttributes) {
        this.routeAttributes = routeAttributes;
    }

    public String getRequestBody() {
        return this.requestBody;
    }

    public void setRequestBody(String requestBody) {
        this.requestBody = requestBody;
    }

    public void setValues(String parameters) {
        String[] keyValues;
        for (String keyValue : keyValues = parameters.split("&")) {
            String[] parts = keyValue.split("=");
            if (parts.length <= 1) continue;
            String key = parts[0];
            String value = parts[1];
            RequestComponent requestComponent = new RequestComponent();
            requestComponent.setName(key);
            requestComponent.setValue(value);
            System.out.println("a:" + key + ":" + value);
            this.requestComponents.put(key, requestComponent);
        }
    }

    public Object inflect(Class<?> klass) {
        Object classInstance = null;
        try {
            Field[] classInstanceFields;
            classInstance = klass.getConstructor(new Class[0]).newInstance(new Object[0]);
            for (Field classInstanceField : classInstanceFields = klass.getDeclaredFields()) {
                String fieldName = classInstanceField.getName();
                String fieldValue = this.getValue(fieldName);
                if (fieldValue == null || fieldValue.equals("")) continue;
                classInstanceField.setAccessible(true);
                Class<?> fieldType = classInstanceField.getType();
                if (fieldType.getTypeName().equals("int") || fieldType.getTypeName().equals("java.lang.Integer")) {
                    classInstanceField.set(classInstance, Integer.valueOf(fieldValue));
                }
                if (fieldType.getTypeName().equals("double") || fieldType.getTypeName().equals("java.lang.Double")) {
                    classInstanceField.set(classInstance, Double.valueOf(fieldValue));
                }
                if (fieldType.getTypeName().equals("float") || fieldType.getTypeName().equals("java.lang.Float")) {
                    classInstanceField.set(classInstance, Float.valueOf(fieldValue));
                }
                if (fieldType.getTypeName().equals("long") || fieldType.getTypeName().equals("java.lang.Long")) {
                    classInstanceField.set(classInstance, Long.valueOf(fieldValue));
                }
                if (fieldType.getTypeName().equals("boolean") || fieldType.getTypeName().equals("java.lang.Boolean")) {
                    classInstanceField.set(classInstance, Boolean.valueOf(fieldValue));
                }
                if (fieldType.getTypeName().equals("java.math.BigDecimal")) {
                    classInstanceField.set(classInstance, new BigDecimal(fieldValue));
                }
                if (!fieldType.getTypeName().equals("java.lang.String")) continue;
                classInstanceField.set(classInstance, fieldValue);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return classInstance;
    }
}

