/*
 * Decompiled with CFR 0.152.
 */
package net.plsar.resources;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.plsar.annotations.Repository;
import net.plsar.annotations.Service;
import net.plsar.resources.AnnotationComponent;
import net.plsar.resources.ComponentsHolder;

public class ComponentAnnotationInspector {
    ClassLoader klassLoader = Thread.currentThread().getContextClassLoader();
    ComponentsHolder componentsHolder;

    public ComponentAnnotationInspector(ComponentsHolder componentsHolder) {
        this.componentsHolder = componentsHolder;
    }

    public void inspect() {
        Path filePath = Paths.get("build", new String[0]);
        String completeFilePath = filePath.toAbsolutePath().toString();
        this.inspectFilePath(completeFilePath);
    }

    public void inspectFilePath(String filePath) {
        File[] files;
        File pathFile = new File(filePath);
        for (File file : files = pathFile.listFiles()) {
            if (file.isDirectory()) {
                this.inspectFilePath(file.getPath());
                continue;
            }
            try {
                String componentKey;
                String[] componentElements;
                AnnotationComponent annotationComponent;
                if (!file.getPath().endsWith(".class")) continue;
                String separator = System.getProperty("file.separator");
                String regex = "classes\\" + separator;
                String[] klassPathParts = file.getPath().split(regex);
                String klassPathSlashesRemoved = klassPathParts[1].replace("\\", ".");
                String klassPathPeriod = klassPathSlashesRemoved.replace("/", ".");
                String klassPathBefore = klassPathPeriod.replace(".class", "");
                String klassPath = klassPathBefore.replaceFirst("java.", "").replaceFirst("main.", "");
                Class<?> klass = this.klassLoader.loadClass(klassPath);
                if (klass.isAnnotation() || klass.isInterface()) continue;
                if (klass.isAnnotationPresent(Repository.class)) {
                    annotationComponent = new AnnotationComponent();
                    annotationComponent.setKlass(klass);
                    componentElements = klass.getName().split("\\.");
                    componentKey = componentElements[componentElements.length - 1].toLowerCase();
                    this.componentsHolder.getRepositories().put(componentKey, klass);
                }
                if (!klass.isAnnotationPresent(Service.class)) continue;
                annotationComponent = new AnnotationComponent();
                annotationComponent.setKlass(klass);
                componentElements = klass.getName().split("\\.");
                componentKey = componentElements[componentElements.length - 1].toLowerCase();
                this.componentsHolder.getServices().put(componentKey, klass);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public ComponentsHolder getComponentsHolder() {
        return this.componentsHolder;
    }
}

