/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.common.v1.util;

public class StringUtils {
    private StringUtils() {
    }

    public static boolean isNull(Object str) {
        return null == str;
    }

    public static boolean isEmpty(String str) {
        return StringUtils.isNull(str) || "".equals(str);
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtils.isEmpty(str);
    }

    public static boolean isBlank(String str) {
        return StringUtils.isNull(str) || StringUtils.isEmpty(str.trim());
    }

    public static boolean isNotBlank(String str) {
        return !StringUtils.isBlank(str);
    }

    public static String join(Object[] array, String separator) {
        if (array == null) {
            return null;
        }
        return StringUtils.join(array, separator, 0, array.length);
    }

    public static String join(Object[] array, String separator, int startIndex, int endIndex) {
        int noOfItems;
        if (array == null) {
            return null;
        }
        if (separator == null) {
            separator = "";
        }
        if ((noOfItems = endIndex - startIndex) <= 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder(noOfItems * 16);
        for (int i = startIndex; i < endIndex; ++i) {
            if (array[i] == null) continue;
            if (i > startIndex) {
                buf.append(separator);
            }
            buf.append(array[i]);
        }
        return buf.toString();
    }
}

