/*
 * Decompiled with CFR 0.152.
 */
package net.rainbowcreation.core.api.utils;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.rainbowcreation.core.api.utils.Console;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class Config {
    private final Plugin plugin;
    private FileConfiguration dataConfig = null;
    private File configFile = null;
    private final String file;
    private Console console;

    public Config(Plugin plugin, String file, Console console) {
        this.plugin = plugin;
        this.file = file;
        this.console = console;
        this.saveDefaultConfig();
    }

    public void reloadConfig() {
        if (this.configFile == null) {
            this.configFile = new File(this.plugin.getDataFolder(), this.file);
        }
        this.dataConfig = YamlConfiguration.loadConfiguration((File)this.configFile);
        InputStream defaultStream = this.plugin.getResource(this.file);
        if (defaultStream != null) {
            YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultStream));
            this.dataConfig.setDefaults((Configuration)defaultConfig);
        }
    }

    public FileConfiguration getConfig() {
        if (this.dataConfig == null) {
            this.reloadConfig();
        }
        return this.dataConfig;
    }

    public void saveConfig() {
        try {
            if (this.dataConfig == null || this.configFile == null) {
                return;
            }
            this.getConfig().save(this.configFile);
        }
        catch (Exception e) {
            this.console.info(e.toString());
        }
    }

    public void saveDefaultConfig() {
        if (this.configFile == null) {
            this.configFile = new File(this.plugin.getDataFolder(), this.file);
        }
        if (!this.configFile.exists()) {
            this.plugin.saveResource(this.file, false);
        }
    }
}

