/*
 * Decompiled with CFR 0.152.
 */
package net.rainbowcreation.core.api.utils;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.rainbowcreation.core.api.IItem;
import net.rainbowcreation.core.api.utils.Chat;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class Item
implements IItem {
    private ItemStack itemStack;
    private Material material;
    private int n = 1;
    private Component displayName;
    private List<String> lore;
    private ItemMeta itemMeta;
    private int i = 0;
    private static final Color[] COLOR_LIST = new Color[]{Color.red, Color.black, Color.blue, Color.cyan, Color.darkGray, Color.gray, Color.green, Color.lightGray, Color.magenta, Color.orange, Color.pink, Color.white, Color.yellow};

    @Override
    public Item material(Material material) {
        this.material = material;
        return this;
    }

    @Override
    public Material getMaterial() {
        return this.material;
    }

    @Override
    public Item amount(int n) {
        this.n = n;
        return this;
    }

    @Override
    public int getAmount() {
        return this.n;
    }

    @Override
    public Item displayName(String mimnimessage) {
        this.displayName = Chat.minimessageComponent(mimnimessage);
        return this;
    }

    @Override
    public Component getName() {
        return this.displayName;
    }

    @Override
    public Item lore(List<String> loreListColored) {
        this.lore = loreListColored;
        return this;
    }

    @Override
    public Item lore(String minimessage) {
        if (this.lore == null) {
            this.lore = new ArrayList<String>();
        }
        this.lore.add(Chat.minimessageColored(minimessage));
        return this;
    }

    @Override
    public List<String> getLore() {
        return this.lore;
    }

    @Override
    public Item customModelData(int modelNumber) {
        this.i = modelNumber;
        return this;
    }

    @Override
    public int getCustomModelData() {
        return this.i;
    }

    @Override
    public ItemStack get() {
        this.itemStack = new ItemStack(this.material, this.n);
        this.itemMeta = this.itemStack.getItemMeta();
        if (this.itemMeta == null) {
            return this.itemStack;
        }
        if (this.displayName != null) {
            this.itemMeta.setDisplayName(Chat.componentColored(this.displayName));
        }
        if (this.lore != null) {
            this.itemMeta.setLore(this.lore);
        }
        if (this.i != 0) {
            try {
                this.itemMeta.setCustomModelData(Integer.valueOf(this.i));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.itemStack.setItemMeta(this.itemMeta);
        return this.itemStack;
    }

    @Override
    public ItemStack getrandomFirework() {
        this.material = Material.FIREWORK_ROCKET;
        FireworkMeta F_itemMeta = (FireworkMeta)this.itemStack.getItemMeta();
        assert (F_itemMeta != null);
        F_itemMeta.setPower((int)(Math.random() * 2.0 + 3.0));
        int rand = (int)(Math.random() * (double)COLOR_LIST.length);
        int rand2 = (int)(Math.random() * (double)COLOR_LIST.length);
        FireworkEffect.Builder F_effect = FireworkEffect.builder();
        F_effect.flicker((int)(Math.random() * 2.0) == 1).withColor((Iterable)((Object)COLOR_LIST[rand]));
        F_effect.withFade((Iterable)((Object)COLOR_LIST[rand2]));
        F_effect.with((int)(Math.random() * 2.0) == 1 ? FireworkEffect.Type.BALL : FireworkEffect.Type.BALL_LARGE);
        F_effect.trail((int)(Math.random() * 2.0) == 1);
        F_itemMeta.addEffect(F_effect.build());
        this.itemStack.setItemMeta((ItemMeta)F_itemMeta);
        return this.itemStack;
    }
}

