/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.plugin.script.internal;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import net.roboconf.core.model.beans.Import;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.core.model.helpers.VariableHelpers;
import net.roboconf.core.utils.ProgramUtils;
import net.roboconf.core.utils.Utils;
import net.roboconf.plugin.api.PluginException;
import net.roboconf.plugin.api.PluginInterface;
import net.roboconf.plugin.api.template.InstanceTemplateHelper;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;

public class PluginScript
implements PluginInterface,
Pojo {
    InstanceManager __IM;
    public static final String PLUGIN_NAME = "script";
    private static final String SCRIPTS_FOLDER_NAME = "scripts";
    private static final String TEMPLATES_FOLDER_NAME = "roboconf-templates";
    private static final String FILES_FOLDER_NAME = "files";
    private boolean __Flogger;
    private final Logger logger;
    private boolean __FagentId;
    String agentId;
    boolean __MgetPluginName;
    boolean __MsetNames$java_lang_String$java_lang_String;
    boolean __Minitialize$net_roboconf_core_model_beans_Instance;
    boolean __Mdeploy$net_roboconf_core_model_beans_Instance;
    boolean __Mstart$net_roboconf_core_model_beans_Instance;
    boolean __Mupdate$net_roboconf_core_model_beans_Instance$net_roboconf_core_model_beans_Import$net_roboconf_core_model_beans_Instance$InstanceStatus;
    boolean __Mstop$net_roboconf_core_model_beans_Instance;
    boolean __Mundeploy$net_roboconf_core_model_beans_Instance;
    boolean __MprepareAndExecuteCommand$java_lang_String$net_roboconf_core_model_beans_Instance$net_roboconf_core_model_beans_Import$net_roboconf_core_model_beans_Instance$InstanceStatus;
    boolean __MgenerateTemplate$java_io_File$net_roboconf_core_model_beans_Instance;
    boolean __MexecuteScript$java_io_File$net_roboconf_core_model_beans_Instance$net_roboconf_core_model_beans_Import$net_roboconf_core_model_beans_Instance$InstanceStatus$java_lang_String;
    boolean __MformatExportedVars$net_roboconf_core_model_beans_Instance;
    boolean __MformatImportedVars$net_roboconf_core_model_beans_Instance;
    boolean __MsetScriptsExecutable$java_io_File;

    Logger __getlogger() {
        if (!this.__Flogger) {
            return this.logger;
        }
        return (Logger)this.__IM.onGet((Object)this, "logger");
    }

    void __setlogger(Logger logger) {
        if (!this.__Flogger) {
            this.logger = logger;
            return;
        }
        this.__IM.onSet((Object)this, "logger", (Object)logger);
    }

    String __getagentId() {
        if (!this.__FagentId) {
            return this.agentId;
        }
        return (String)this.__IM.onGet((Object)this, "agentId");
    }

    void __setagentId(String string) {
        if (!this.__FagentId) {
            this.agentId = string;
            return;
        }
        this.__IM.onSet((Object)this, "agentId", (Object)string);
    }

    public PluginScript() {
        this(null);
    }

    private PluginScript(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setlogger(Logger.getLogger(this.getClass().getName()));
    }

    public String getPluginName() {
        String string;
        if (!this.__MgetPluginName) {
            return this.__M_getPluginName();
        }
        try {
            this.__IM.onEntry((Object)this, "getPluginName", new Object[0]);
            string = this.__M_getPluginName();
            this.__IM.onExit((Object)this, "getPluginName", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getPluginName", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getPluginName() {
        return PLUGIN_NAME;
    }

    public void setNames(String applicationName, String rootInstanceName) {
        if (!this.__MsetNames$java_lang_String$java_lang_String) {
            this.__M_setNames(applicationName, rootInstanceName);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setNames$java_lang_String$java_lang_String", new Object[]{applicationName, rootInstanceName});
            this.__M_setNames(applicationName, rootInstanceName);
            this.__IM.onExit((Object)this, "setNames$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setNames$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_setNames(String applicationName, String rootInstanceName) {
        this.__setagentId("'" + rootInstanceName + "' agent");
    }

    public void initialize(Instance instance) throws PluginException {
        if (!this.__Minitialize$net_roboconf_core_model_beans_Instance) {
            this.__M_initialize(instance);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "initialize$net_roboconf_core_model_beans_Instance", new Object[]{instance});
            this.__M_initialize(instance);
            this.__IM.onExit((Object)this, "initialize$net_roboconf_core_model_beans_Instance", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "initialize$net_roboconf_core_model_beans_Instance", throwable);
            throw throwable;
        }
    }

    private void __M_initialize(Instance instance) throws PluginException {
        this.__getlogger().fine(this.__getagentId() + ": initializing the plugin for " + instance);
        File instanceDirectory = InstanceHelpers.findInstanceDirectoryOnAgent((Instance)instance);
        this.setScriptsExecutable(new File(instanceDirectory, SCRIPTS_FOLDER_NAME));
    }

    public void deploy(Instance instance) throws PluginException {
        if (!this.__Mdeploy$net_roboconf_core_model_beans_Instance) {
            this.__M_deploy(instance);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "deploy$net_roboconf_core_model_beans_Instance", new Object[]{instance});
            this.__M_deploy(instance);
            this.__IM.onExit((Object)this, "deploy$net_roboconf_core_model_beans_Instance", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "deploy$net_roboconf_core_model_beans_Instance", throwable);
            throw throwable;
        }
    }

    private void __M_deploy(Instance instance) throws PluginException {
        this.__getlogger().fine(this.__getagentId() + " is deploying instance " + instance);
        try {
            this.prepareAndExecuteCommand("deploy", instance, null, null);
        }
        catch (Exception e) {
            throw new PluginException((Throwable)e);
        }
    }

    public void start(Instance instance) throws PluginException {
        if (!this.__Mstart$net_roboconf_core_model_beans_Instance) {
            this.__M_start(instance);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start$net_roboconf_core_model_beans_Instance", new Object[]{instance});
            this.__M_start(instance);
            this.__IM.onExit((Object)this, "start$net_roboconf_core_model_beans_Instance", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start$net_roboconf_core_model_beans_Instance", throwable);
            throw throwable;
        }
    }

    private void __M_start(Instance instance) throws PluginException {
        this.__getlogger().fine(this.__getagentId() + " is starting instance " + instance);
        try {
            this.prepareAndExecuteCommand("start", instance, null, null);
        }
        catch (Exception e) {
            throw new PluginException((Throwable)e);
        }
    }

    public void update(Instance instance, Import importChanged, Instance.InstanceStatus statusChanged) throws PluginException {
        if (!this.__Mupdate$net_roboconf_core_model_beans_Instance$net_roboconf_core_model_beans_Import$net_roboconf_core_model_beans_Instance$InstanceStatus) {
            this.__M_update(instance, importChanged, statusChanged);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "update$net_roboconf_core_model_beans_Instance$net_roboconf_core_model_beans_Import$net_roboconf_core_model_beans_Instance$InstanceStatus", new Object[]{instance, importChanged, statusChanged});
            this.__M_update(instance, importChanged, statusChanged);
            this.__IM.onExit((Object)this, "update$net_roboconf_core_model_beans_Instance$net_roboconf_core_model_beans_Import$net_roboconf_core_model_beans_Instance$InstanceStatus", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "update$net_roboconf_core_model_beans_Instance$net_roboconf_core_model_beans_Import$net_roboconf_core_model_beans_Instance$InstanceStatus", throwable);
            throw throwable;
        }
    }

    private void __M_update(Instance instance, Import importChanged, Instance.InstanceStatus statusChanged) throws PluginException {
        this.__getlogger().fine(this.__getagentId() + " is updating instance " + instance);
        try {
            this.prepareAndExecuteCommand("update", instance, importChanged, statusChanged);
        }
        catch (Exception e) {
            throw new PluginException((Throwable)e);
        }
    }

    public void stop(Instance instance) throws PluginException {
        if (!this.__Mstop$net_roboconf_core_model_beans_Instance) {
            this.__M_stop(instance);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop$net_roboconf_core_model_beans_Instance", new Object[]{instance});
            this.__M_stop(instance);
            this.__IM.onExit((Object)this, "stop$net_roboconf_core_model_beans_Instance", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop$net_roboconf_core_model_beans_Instance", throwable);
            throw throwable;
        }
    }

    private void __M_stop(Instance instance) throws PluginException {
        this.__getlogger().fine(this.__getagentId() + " is stopping instance " + instance);
        try {
            this.prepareAndExecuteCommand("stop", instance, null, null);
        }
        catch (Exception e) {
            throw new PluginException((Throwable)e);
        }
    }

    public void undeploy(Instance instance) throws PluginException {
        if (!this.__Mundeploy$net_roboconf_core_model_beans_Instance) {
            this.__M_undeploy(instance);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "undeploy$net_roboconf_core_model_beans_Instance", new Object[]{instance});
            this.__M_undeploy(instance);
            this.__IM.onExit((Object)this, "undeploy$net_roboconf_core_model_beans_Instance", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "undeploy$net_roboconf_core_model_beans_Instance", throwable);
            throw throwable;
        }
    }

    private void __M_undeploy(Instance instance) throws PluginException {
        this.__getlogger().fine(this.__getagentId() + " is undeploying instance " + instance);
        try {
            this.prepareAndExecuteCommand("undeploy", instance, null, null);
        }
        catch (Exception e) {
            throw new PluginException((Throwable)e);
        }
    }

    private void prepareAndExecuteCommand(String action, Instance instance, Import importChanged, Instance.InstanceStatus statusChanged) throws IOException, InterruptedException {
        if (!this.__MprepareAndExecuteCommand$java_lang_String$net_roboconf_core_model_beans_Instance$net_roboconf_core_model_beans_Import$net_roboconf_core_model_beans_Instance$InstanceStatus) {
            this.__M_prepareAndExecuteCommand(action, instance, importChanged, statusChanged);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "prepareAndExecuteCommand$java_lang_String$net_roboconf_core_model_beans_Instance$net_roboconf_core_model_beans_Import$net_roboconf_core_model_beans_Instance$InstanceStatus", new Object[]{action, instance, importChanged, statusChanged});
            this.__M_prepareAndExecuteCommand(action, instance, importChanged, statusChanged);
            this.__IM.onExit((Object)this, "prepareAndExecuteCommand$java_lang_String$net_roboconf_core_model_beans_Instance$net_roboconf_core_model_beans_Import$net_roboconf_core_model_beans_Instance$InstanceStatus", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "prepareAndExecuteCommand$java_lang_String$net_roboconf_core_model_beans_Instance$net_roboconf_core_model_beans_Import$net_roboconf_core_model_beans_Instance$InstanceStatus", throwable);
            throw throwable;
        }
    }

    private void __M_prepareAndExecuteCommand(String action, Instance instance, Import importChanged, Instance.InstanceStatus statusChanged) throws IOException, InterruptedException {
        File template;
        File[] foundFiles;
        this.__getlogger().info("Preparing the invocation of " + action + " script for instance " + instance);
        File instanceDirectory = InstanceHelpers.findInstanceDirectoryOnAgent((Instance)instance);
        File scriptsFolder = new File(instanceDirectory, SCRIPTS_FOLDER_NAME);
        File templatesFolder = new File(instanceDirectory, TEMPLATES_FOLDER_NAME);
        File script = new File(scriptsFolder, action + ".sh");
        if (!script.exists() && (foundFiles = scriptsFolder.listFiles(new ActionFileFilter(action))) != null && foundFiles.length > 0) {
            script = foundFiles[0];
            if (foundFiles.length > 1) {
                this.__getlogger().warning("More than one " + action + " script found: taking the 1st one, " + script.getName());
            }
        }
        if (!(template = new File(templatesFolder, action + ".template")).exists()) {
            template = new File(templatesFolder, "default.template");
        }
        if (script.exists()) {
            this.executeScript(script, instance, importChanged, statusChanged, instanceDirectory.getAbsolutePath());
        } else if (template.exists()) {
            File generated = this.generateTemplate(template, instance);
            this.executeScript(generated, instance, importChanged, statusChanged, instanceDirectory.getAbsolutePath());
            Utils.deleteFilesRecursively((File[])new File[]{generated});
        } else {
            this.__getlogger().warning("Can not find a script or a template for action " + action);
        }
    }

    protected File generateTemplate(File template, Instance instance) throws IOException {
        File file;
        if (!this.__MgenerateTemplate$java_io_File$net_roboconf_core_model_beans_Instance) {
            return this.__M_generateTemplate(template, instance);
        }
        try {
            this.__IM.onEntry((Object)this, "generateTemplate$java_io_File$net_roboconf_core_model_beans_Instance", new Object[]{template, instance});
            file = this.__M_generateTemplate(template, instance);
            this.__IM.onExit((Object)this, "generateTemplate$java_io_File$net_roboconf_core_model_beans_Instance", (Object)file);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "generateTemplate$java_io_File$net_roboconf_core_model_beans_Instance", throwable);
            throw throwable;
        }
        return file;
    }

    private File __M_generateTemplate(File template, Instance instance) throws IOException {
        File generated = File.createTempFile(instance.getName(), ".script");
        InstanceTemplateHelper.injectInstanceImports((Instance)instance, (File)template, (File)generated);
        return generated;
    }

    protected void executeScript(File script, Instance instance, Import importChanged, Instance.InstanceStatus statusChanged, String instanceDir) throws IOException, InterruptedException {
        if (!this.__MexecuteScript$java_io_File$net_roboconf_core_model_beans_Instance$net_roboconf_core_model_beans_Import$net_roboconf_core_model_beans_Instance$InstanceStatus$java_lang_String) {
            this.__M_executeScript(script, instance, importChanged, statusChanged, instanceDir);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "executeScript$java_io_File$net_roboconf_core_model_beans_Instance$net_roboconf_core_model_beans_Import$net_roboconf_core_model_beans_Instance$InstanceStatus$java_lang_String", new Object[]{script, instance, importChanged, statusChanged, instanceDir});
            this.__M_executeScript(script, instance, importChanged, statusChanged, instanceDir);
            this.__IM.onExit((Object)this, "executeScript$java_io_File$net_roboconf_core_model_beans_Instance$net_roboconf_core_model_beans_Import$net_roboconf_core_model_beans_Instance$InstanceStatus$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "executeScript$java_io_File$net_roboconf_core_model_beans_Instance$net_roboconf_core_model_beans_Import$net_roboconf_core_model_beans_Instance$InstanceStatus$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_executeScript(File script, Instance instance, Import importChanged, Instance.InstanceStatus statusChanged, String instanceDir) throws IOException, InterruptedException {
        int exitCode;
        String[] command = new String[]{script.getAbsolutePath()};
        if (!script.canExecute()) {
            script.setExecutable(true);
        }
        HashMap<String, String> environmentVars = new HashMap<String, String>();
        Map<String, String> vars = this.formatExportedVars(instance);
        environmentVars.putAll(vars);
        Map<String, String> importedVars = this.formatImportedVars(instance);
        environmentVars.putAll(importedVars);
        environmentVars.put("ROBOCONF_INSTANCE_NAME", instance.getName());
        environmentVars.put("ROBOCONF_FILES_DIR", new File(instanceDir, FILES_FOLDER_NAME).getAbsolutePath());
        if (statusChanged != null) {
            environmentVars.put("ROBOCONF_UPDATE_STATUS", statusChanged.toString());
        }
        if (importChanged != null) {
            environmentVars.put("ROBOCONF_IMPORT_CHANGED_INSTANCE_PATH", importChanged.getInstancePath());
            environmentVars.put("ROBOCONF_IMPORT_CHANGED_COMPONENT", importChanged.getComponentName());
            for (Map.Entry entry : importChanged.getExportedVars().entrySet()) {
                String vname = (String)VariableHelpers.parseVariableName((String)((String)entry.getKey())).getValue();
                importedVars.put("ROBOCONF_IMPORT_CHANGED_" + vname, (String)entry.getValue());
            }
        }
        if ((exitCode = ProgramUtils.executeCommand((Logger)this.__getlogger(), (String[])command, (File)script.getParentFile(), environmentVars)) != 0) {
            throw new IOException("Script execution failed. Exit code: " + exitCode);
        }
    }

    private Map<String, String> formatExportedVars(Instance instance) {
        Map<String, String> map;
        if (!this.__MformatExportedVars$net_roboconf_core_model_beans_Instance) {
            return this.__M_formatExportedVars(instance);
        }
        try {
            this.__IM.onEntry((Object)this, "formatExportedVars$net_roboconf_core_model_beans_Instance", new Object[]{instance});
            map = this.__M_formatExportedVars(instance);
            this.__IM.onExit((Object)this, "formatExportedVars$net_roboconf_core_model_beans_Instance", map);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "formatExportedVars$net_roboconf_core_model_beans_Instance", throwable);
            throw throwable;
        }
        return map;
    }

    private Map<String, String> __M_formatExportedVars(Instance instance) {
        HashMap<String, String> exportedVars = new HashMap<String, String>();
        Map exports = InstanceHelpers.findAllExportedVariables((Instance)instance);
        for (Map.Entry entry : exports.entrySet()) {
            String vname = (String)VariableHelpers.parseVariableName((String)((String)entry.getKey())).getValue();
            exportedVars.put(vname, (String)entry.getValue());
        }
        return exportedVars;
    }

    private Map<String, String> formatImportedVars(Instance instance) {
        Map<String, String> map;
        if (!this.__MformatImportedVars$net_roboconf_core_model_beans_Instance) {
            return this.__M_formatImportedVars(instance);
        }
        try {
            this.__IM.onEntry((Object)this, "formatImportedVars$net_roboconf_core_model_beans_Instance", new Object[]{instance});
            map = this.__M_formatImportedVars(instance);
            this.__IM.onExit((Object)this, "formatImportedVars$net_roboconf_core_model_beans_Instance", map);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "formatImportedVars$net_roboconf_core_model_beans_Instance", throwable);
            throw throwable;
        }
        return map;
    }

    private Map<String, String> __M_formatImportedVars(Instance instance) {
        HashMap<String, String> importedVars = new HashMap<String, String>();
        for (Map.Entry entry : instance.getImports().entrySet()) {
            Collection importList = (Collection)entry.getValue();
            String importTypeName = (String)entry.getKey();
            importedVars.put(importTypeName + "_size", "" + importList.size());
            int i = 0;
            for (Import imprt : importList) {
                importedVars.put(importTypeName + "_" + i + "_name", imprt.getInstancePath());
                for (Map.Entry entry2 : imprt.getExportedVars().entrySet()) {
                    String vname = (String)VariableHelpers.parseVariableName((String)((String)entry2.getKey())).getValue();
                    importedVars.put(importTypeName + "_" + i + "_" + vname, (String)entry2.getValue());
                }
                ++i;
            }
        }
        return importedVars;
    }

    void setScriptsExecutable(File dir) {
        if (!this.__MsetScriptsExecutable$java_io_File) {
            this.__M_setScriptsExecutable(dir);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setScriptsExecutable$java_io_File", new Object[]{dir});
            this.__M_setScriptsExecutable(dir);
            this.__IM.onExit((Object)this, "setScriptsExecutable$java_io_File", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setScriptsExecutable$java_io_File", throwable);
            throw throwable;
        }
    }

    private void __M_setScriptsExecutable(File dir) {
        if (dir.isDirectory()) {
            for (File f : Utils.listAllFiles((File)dir, (boolean)true)) {
                f.setExecutable(true);
            }
        }
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("agentId")) {
                this.__FagentId = true;
            }
            if (set.contains("logger")) {
                this.__Flogger = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("getPluginName")) {
                this.__MgetPluginName = true;
            }
            if (set.contains("setNames$java_lang_String$java_lang_String")) {
                this.__MsetNames$java_lang_String$java_lang_String = true;
            }
            if (set.contains("initialize$net_roboconf_core_model_beans_Instance")) {
                this.__Minitialize$net_roboconf_core_model_beans_Instance = true;
            }
            if (set.contains("deploy$net_roboconf_core_model_beans_Instance")) {
                this.__Mdeploy$net_roboconf_core_model_beans_Instance = true;
            }
            if (set.contains("start$net_roboconf_core_model_beans_Instance")) {
                this.__Mstart$net_roboconf_core_model_beans_Instance = true;
            }
            if (set.contains("update$net_roboconf_core_model_beans_Instance$net_roboconf_core_model_beans_Import$net_roboconf_core_model_beans_Instance$InstanceStatus")) {
                this.__Mupdate$net_roboconf_core_model_beans_Instance$net_roboconf_core_model_beans_Import$net_roboconf_core_model_beans_Instance$InstanceStatus = true;
            }
            if (set.contains("stop$net_roboconf_core_model_beans_Instance")) {
                this.__Mstop$net_roboconf_core_model_beans_Instance = true;
            }
            if (set.contains("undeploy$net_roboconf_core_model_beans_Instance")) {
                this.__Mundeploy$net_roboconf_core_model_beans_Instance = true;
            }
            if (set.contains("prepareAndExecuteCommand$java_lang_String$net_roboconf_core_model_beans_Instance$net_roboconf_core_model_beans_Import$net_roboconf_core_model_beans_Instance$InstanceStatus")) {
                this.__MprepareAndExecuteCommand$java_lang_String$net_roboconf_core_model_beans_Instance$net_roboconf_core_model_beans_Import$net_roboconf_core_model_beans_Instance$InstanceStatus = true;
            }
            if (set.contains("generateTemplate$java_io_File$net_roboconf_core_model_beans_Instance")) {
                this.__MgenerateTemplate$java_io_File$net_roboconf_core_model_beans_Instance = true;
            }
            if (set.contains("executeScript$java_io_File$net_roboconf_core_model_beans_Instance$net_roboconf_core_model_beans_Import$net_roboconf_core_model_beans_Instance$InstanceStatus$java_lang_String")) {
                this.__MexecuteScript$java_io_File$net_roboconf_core_model_beans_Instance$net_roboconf_core_model_beans_Import$net_roboconf_core_model_beans_Instance$InstanceStatus$java_lang_String = true;
            }
            if (set.contains("formatExportedVars$net_roboconf_core_model_beans_Instance")) {
                this.__MformatExportedVars$net_roboconf_core_model_beans_Instance = true;
            }
            if (set.contains("formatImportedVars$net_roboconf_core_model_beans_Instance")) {
                this.__MformatImportedVars$net_roboconf_core_model_beans_Instance = true;
            }
            if (set.contains("setScriptsExecutable$java_io_File")) {
                this.__MsetScriptsExecutable$java_io_File = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }

    static class ActionFileFilter
    implements FilenameFilter {
        final String prefix;

        public ActionFileFilter(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public boolean accept(File dir, String name) {
            return this.prefix == null || this.prefix.length() < 1 ? false : name.startsWith(this.prefix);
        }
    }
}

