/*
 * Decompiled with CFR 0.152.
 */
package net.sf.asterisk.fastagi;

import java.io.IOException;
import net.sf.asterisk.fastagi.AGIException;
import net.sf.asterisk.fastagi.AGIReader;
import net.sf.asterisk.fastagi.AGIRequest;
import net.sf.asterisk.fastagi.AGIScript;
import net.sf.asterisk.fastagi.AGIWriter;
import net.sf.asterisk.fastagi.MappingStrategy;
import net.sf.asterisk.fastagi.command.VerboseCommand;
import net.sf.asterisk.fastagi.impl.AGIChannelImpl;
import net.sf.asterisk.fastagi.impl.AGIReaderImpl;
import net.sf.asterisk.fastagi.impl.AGIWriterImpl;
import net.sf.asterisk.io.SocketConnectionFacade;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AGIConnectionHandler
implements Runnable {
    private final Log logger = LogFactory.getLog(this.getClass());
    private SocketConnectionFacade socket;
    private MappingStrategy mappingStrategy;

    public AGIConnectionHandler(SocketConnectionFacade socket, MappingStrategy mappingStrategy) {
        this.socket = socket;
        this.mappingStrategy = mappingStrategy;
    }

    protected AGIReader createReader() {
        return new AGIReaderImpl(this.socket);
    }

    protected AGIWriter createWriter() {
        return new AGIWriterImpl(this.socket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            AGIReader reader = this.createReader();
            AGIWriter writer = this.createWriter();
            AGIRequest request = reader.readRequest();
            AGIChannelImpl channel = new AGIChannelImpl(writer, reader);
            AGIScript script = this.mappingStrategy.determineScript(request);
            String threadName = Thread.currentThread().getName();
            if (script != null) {
                this.logger.info((Object)("Begin AGIScript " + script.getClass().getName() + " on " + threadName));
                script.service(request, channel);
                this.logger.info((Object)("End AGIScript " + script.getClass().getName() + " on " + threadName));
            } else {
                String error = "No script configured for " + request.getRequestURL();
                channel.sendCommand(new VerboseCommand(error, 1));
                this.logger.error((Object)error);
            }
        }
        catch (AGIException e) {
            this.logger.error((Object)("AGIException while handling request: " + e.getMessage()));
        }
        catch (Exception e) {
            this.logger.error((Object)"Unexpected Exception while handling request", (Throwable)e);
        }
        finally {
            try {
                this.socket.close();
            }
            catch (IOException e) {}
        }
    }
}

