/*
 * Decompiled with CFR 0.152.
 */
package net.sf.asterisk.fastagi.reply;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class AGIReply
implements Serializable {
    public static int SC_SUCCESS = 200;
    public static int SC_INVALID_OR_UNKNOWN_COMMAND = 510;
    public static int SC_INVALID_COMMAND_SYNTAX = 520;
    private static final long serialVersionUID = 3256727294671337012L;
    private String result;
    private int status;
    private Map attributes;
    private String extra;
    private String synopsis;
    private String usage;

    public int getResultCode() {
        if (this.result == null) {
            return -1;
        }
        try {
            return Integer.parseInt(this.result);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public char getResultCodeAsChar() {
        int resultCode = this.getResultCode();
        if (resultCode < 0) {
            return '\u0000';
        }
        return (char)resultCode;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getAttribute(String name) {
        if ("result".equalsIgnoreCase(name)) {
            return this.getResult();
        }
        if (this.attributes == null) {
            return null;
        }
        return (String)this.attributes.get(name.toLowerCase());
    }

    public void setAttribute(String name, String value) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(name.toLowerCase(), value);
    }

    public String getExtra() {
        return this.extra;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public String getSynopsis() {
        return this.synopsis;
    }

    public void setSynopsis(String synopsis) {
        this.synopsis = synopsis;
    }

    public String getUsage() {
        return this.usage;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName() + ": ");
        sb.append("status='" + this.getStatus() + "'; ");
        if (this.status == SC_SUCCESS) {
            sb.append("result='" + this.getResult() + "'; ");
            sb.append("extra='" + this.getExtra() + "'; ");
            sb.append("attributes=" + this.attributes + "; ");
        }
        if (this.status == SC_INVALID_COMMAND_SYNTAX) {
            sb.append("synopsis='" + this.getSynopsis() + "'; ");
        }
        sb.append("systemHashcode=" + System.identityHashCode(this));
        return sb.toString();
    }
}

