/*
 * Decompiled with CFR 0.152.
 */
package net.sf.asterisk.manager;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.asterisk.manager.AsteriskManager;
import net.sf.asterisk.manager.AuthenticationFailedException;
import net.sf.asterisk.manager.Channel;
import net.sf.asterisk.manager.ChannelStateEnum;
import net.sf.asterisk.manager.ManagerConnection;
import net.sf.asterisk.manager.ManagerEventHandler;
import net.sf.asterisk.manager.Queue;
import net.sf.asterisk.manager.TimeoutException;
import net.sf.asterisk.manager.action.OriginateAction;
import net.sf.asterisk.manager.action.QueueStatusAction;
import net.sf.asterisk.manager.action.StatusAction;
import net.sf.asterisk.manager.event.ConnectEvent;
import net.sf.asterisk.manager.event.DisconnectEvent;
import net.sf.asterisk.manager.event.HangupEvent;
import net.sf.asterisk.manager.event.LinkEvent;
import net.sf.asterisk.manager.event.ManagerEvent;
import net.sf.asterisk.manager.event.NewChannelEvent;
import net.sf.asterisk.manager.event.NewExtenEvent;
import net.sf.asterisk.manager.event.NewStateEvent;
import net.sf.asterisk.manager.event.QueueEntryEvent;
import net.sf.asterisk.manager.event.QueueMemberEvent;
import net.sf.asterisk.manager.event.QueueParamsEvent;
import net.sf.asterisk.manager.event.RenameEvent;
import net.sf.asterisk.manager.event.StatusCompleteEvent;
import net.sf.asterisk.manager.event.StatusEvent;
import net.sf.asterisk.manager.event.UnlinkEvent;
import net.sf.asterisk.manager.response.ManagerResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultAsteriskManager
implements AsteriskManager,
ManagerEventHandler {
    private final Log log = LogFactory.getLog(this.getClass());
    private ManagerConnection connection;
    private Map channels = Collections.synchronizedMap(new HashMap());
    private Map queues = Collections.synchronizedMap(new HashMap());
    private List queuedEvents = Collections.synchronizedList(new ArrayList());
    private boolean channelsInitialized = false;
    private boolean queuesInitialized = true;
    private boolean initialized = false;
    private boolean loggedIn = false;

    public void setManagerConnection(ManagerConnection connection) {
        this.connection = connection;
    }

    public void initialize() throws TimeoutException, IOException, AuthenticationFailedException {
        this.connection.addEventHandler(this);
        this.connection.login();
        this.loggedIn = true;
        this.connection.sendAction(new StatusAction());
        this.connection.sendAction(new QueueStatusAction());
    }

    public String originateCall(OriginateAction originateAction) throws TimeoutException, IOException {
        ManagerResponse response = this.connection.sendAction(originateAction);
        return response == null ? null : response.getUniqueId();
    }

    public Map getChannels() {
        return this.channels;
    }

    public Map getQueues() {
        return this.queues;
    }

    public void handleEvent(ManagerEvent event) {
        System.out.println("received: " + event);
        if (event instanceof ConnectEvent) {
            this.handleConnectEvent((ConnectEvent)event);
        } else if (event instanceof DisconnectEvent) {
            this.handleDisconnectEvent((DisconnectEvent)event);
        }
        if (!this.initialized) {
            if (event instanceof StatusEvent) {
                this.handleStatusEvent((StatusEvent)event);
            } else if (event instanceof StatusCompleteEvent) {
                this.handleStatusCompleteEvent((StatusCompleteEvent)event);
            } else if (event instanceof QueueParamsEvent) {
                this.handleQueueParamsEvent((QueueParamsEvent)event);
            } else if (event instanceof QueueMemberEvent) {
                this.handleQueueMemberEvent((QueueMemberEvent)event);
            } else if (event instanceof QueueEntryEvent) {
                this.handleQueueEntryEvent((QueueEntryEvent)event);
            } else {
                this.queuedEvents.add(event);
            }
            if (this.channelsInitialized && this.queuesInitialized) {
                Iterator i = this.queuedEvents.iterator();
                while (i.hasNext()) {
                    ManagerEvent queuedEvent = (ManagerEvent)i.next();
                    this.dispatchEvent(queuedEvent);
                    i.remove();
                }
                this.initialized = true;
            }
        } else {
            this.dispatchEvent(event);
        }
    }

    protected void dispatchEvent(ManagerEvent event) {
        if (event instanceof NewChannelEvent) {
            this.handleNewChannelEvent((NewChannelEvent)event);
        } else if (event instanceof NewExtenEvent) {
            this.handleNewExtenEvent((NewExtenEvent)event);
        } else if (event instanceof NewStateEvent) {
            this.handleNewStateEvent((NewStateEvent)event);
        } else if (event instanceof LinkEvent) {
            this.handleLinkEvent((LinkEvent)event);
        } else if (event instanceof UnlinkEvent) {
            this.handleUnlinkEvent((UnlinkEvent)event);
        } else if (event instanceof RenameEvent) {
            this.handleRenameEvent((RenameEvent)event);
        } else if (event instanceof HangupEvent) {
            this.handleHangupEvent((HangupEvent)event);
        }
    }

    protected void addChannel(Channel channel) {
        this.channels.put(channel.getId(), channel);
    }

    protected void removeChannel(Channel channel) {
        this.channels.remove(channel.getId());
    }

    protected void addQueue(Queue queue) {
        this.queues.put(queue.getName(), queue);
    }

    protected void removeQueue(Queue queue) {
        this.queues.remove(queue.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleStatusEvent(StatusEvent event) {
        boolean isNew = false;
        Channel channel = (Channel)this.channels.get(event.getUniqueId());
        if (channel == null) {
            channel = new Channel(event.getChannel(), event.getUniqueId());
            if (event.getSeconds() != null) {
                channel.setDateOfCreation(new Date(System.currentTimeMillis() - (long)(event.getSeconds() * 1000)));
            }
            isNew = true;
        }
        Channel channel2 = channel;
        synchronized (channel2) {
            Channel linkedChannel;
            channel.setCallerId(event.getCallerId());
            channel.setAccount(event.getAccount());
            channel.setState(ChannelStateEnum.getEnum(event.getState()));
            channel.setContext(event.getContext());
            channel.setExtension(event.getExtension());
            channel.setPriority(event.getPriority());
            if (event.getLink() != null && (linkedChannel = this.getChannelByName(event.getLink())) != null) {
                channel.setLinkedChannel(linkedChannel);
                Channel channel3 = linkedChannel;
                synchronized (channel3) {
                    linkedChannel.setLinkedChannel(channel);
                }
            }
        }
        if (isNew) {
            this.log.info((Object)("Adding new channel " + channel.getName()));
            this.addChannel(channel);
        }
    }

    protected void handleStatusCompleteEvent(StatusCompleteEvent event) {
        this.log.info((Object)"Channels are now initialized");
        this.channelsInitialized = true;
    }

    protected void handleDisconnectEvent(DisconnectEvent disconnectEvent) {
        this.channels.clear();
        this.queues.clear();
        this.queuedEvents.clear();
        this.channelsInitialized = false;
        this.queuesInitialized = true;
        this.initialized = false;
    }

    protected void handleConnectEvent(ConnectEvent connectEvent) {
        if (!this.loggedIn) {
            return;
        }
        try {
            this.connection.sendAction(new StatusAction());
        }
        catch (Exception e) {
            this.log.error((Object)"Unable to request channel status from asterisk server after reconnect.", (Throwable)e);
        }
        try {
            this.connection.sendAction(new QueueStatusAction());
        }
        catch (Exception e) {
            this.log.error((Object)"Unable to request queue status from asterisk server after reconnect.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleQueueParamsEvent(QueueParamsEvent event) {
        boolean isNew = false;
        Queue queue = (Queue)this.queues.get(event.getQueue());
        if (queue == null) {
            queue = new Queue(event.getQueue());
            isNew = true;
        }
        Queue queue2 = queue;
        synchronized (queue2) {
            queue.setMax(event.getMax());
        }
        if (isNew) {
            this.log.info((Object)("Adding new queue " + queue.getName()));
            this.addQueue(queue);
        }
    }

    protected void handleQueueMemberEvent(QueueMemberEvent event) {
    }

    protected void handleQueueEntryEvent(QueueEntryEvent event) {
        Queue queue = (Queue)this.queues.get(event.getQueue());
        Channel channel = this.getChannelByName(event.getChannel());
        if (queue == null) {
            this.log.error((Object)("ignored QueueEntryEvent for unknown queue " + event.getQueue()));
            return;
        }
        if (channel == null) {
            this.log.error((Object)("ignored QueueEntryEvent for unknown channel " + event.getChannel()));
            return;
        }
        if (!queue.getEntries().contains(channel)) {
            queue.addEntry(channel);
        }
    }

    private Channel getChannelByName(String name) {
        Channel channel = null;
        Iterator channelIterator = this.channels.values().iterator();
        while (channelIterator.hasNext()) {
            Channel tmp = (Channel)channelIterator.next();
            if (tmp.getName() == null || !tmp.getName().equals(name)) continue;
            channel = tmp;
        }
        return channel;
    }

    protected void handleNewChannelEvent(NewChannelEvent event) {
        Channel channel = new Channel(event.getChannel(), event.getUniqueId());
        channel.setCallerId(event.getCallerId());
        channel.setState(ChannelStateEnum.getEnum(event.getState()));
        this.log.info((Object)("Adding channel " + channel.getName()));
        this.addChannel(channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleNewExtenEvent(NewExtenEvent event) {
        Channel channel = (Channel)this.channels.get(event.getUniqueId());
        if (channel == null) {
            this.log.error((Object)("Ignored NewExtenEvent for unknown channel " + event.getChannel()));
            return;
        }
        Channel channel2 = channel;
        synchronized (channel2) {
            channel.setContext(event.getContext());
            channel.setExtension(event.getExtension());
            channel.setPriority(event.getPriority());
            channel.setApplication(event.getApplication());
            channel.setAppData(event.getAppData());
        }
    }

    protected void handleNewStateEvent(NewStateEvent event) {
        Channel channel = (Channel)this.channels.get(event.getUniqueId());
        if (channel == null) {
            this.log.error((Object)("Ignored NewStateEvent for unknown channel " + event.getChannel()));
            return;
        }
        channel.setState(ChannelStateEnum.getEnum(event.getState()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleHangupEvent(HangupEvent event) {
        Channel channel = (Channel)this.channels.get(event.getUniqueId());
        if (channel == null) {
            this.log.error((Object)("Ignored HangupEvent for unknown channel " + event.getChannel()));
            return;
        }
        Channel channel2 = channel;
        synchronized (channel2) {
            channel.setState(ChannelStateEnum.HUNGUP);
        }
        this.log.info((Object)("Removing channel " + channel.getName() + " due to hangup"));
        this.removeChannel(channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleLinkEvent(LinkEvent event) {
        Channel channel1 = (Channel)this.channels.get(event.getUniqueId1());
        Channel channel2 = (Channel)this.channels.get(event.getUniqueId2());
        if (channel1 == null) {
            this.log.error((Object)("Ignored LinkEvent for unknown channel " + event.getChannel1()));
            return;
        }
        if (channel2 == null) {
            this.log.error((Object)("Ignored LinkEvent for unknown channel " + event.getChannel2()));
            return;
        }
        this.log.info((Object)("Linking channels " + channel1.getName() + " and " + channel2.getName()));
        DefaultAsteriskManager defaultAsteriskManager = this;
        synchronized (defaultAsteriskManager) {
            channel1.setLinkedChannel(channel2);
            channel2.setLinkedChannel(channel1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleUnlinkEvent(UnlinkEvent event) {
        Channel channel1 = this.getChannelByName(event.getChannel1());
        Channel channel2 = this.getChannelByName(event.getChannel2());
        if (channel1 == null) {
            this.log.error((Object)("Ignored UnlinkEvent for unknown channel " + event.getChannel1()));
            return;
        }
        if (channel2 == null) {
            this.log.error((Object)("Ignored UnlinkEvent for unknown channel " + event.getChannel2()));
            return;
        }
        this.log.info((Object)("Unlinking channels " + channel1.getName() + " and " + channel2.getName()));
        Channel channel = channel1;
        synchronized (channel) {
            channel1.setLinkedChannel(null);
        }
        channel = channel2;
        synchronized (channel) {
            channel2.setLinkedChannel(null);
        }
    }

    protected void handleRenameEvent(RenameEvent event) {
        Channel channel = (Channel)this.channels.get(event.getUniqueId());
        this.log.info((Object)("Renaming channel '" + channel.getName() + "' to '" + event.getNewname() + "'"));
        channel.setName(event.getNewname());
    }
}

