/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.sqlparam;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import net.sourceforge.squirrel_sql.client.gui.session.ObjectTreeInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.session.SQLInternalFrame;
import net.sourceforge.squirrel_sql.client.plugin.DefaultSessionPlugin;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.plugin.PluginException;
import net.sourceforge.squirrel_sql.client.plugin.PluginResources;
import net.sourceforge.squirrel_sql.client.plugin.PluginSessionCallback;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.event.ISQLExecutionListener;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.sqlparam.Resources;
import net.sourceforge.squirrel_sql.plugins.sqlparam.SQLParamExecutionListener;

public class SQLParamPlugin
extends DefaultSessionPlugin {
    private static final ILogger log = LoggerController.createLogger(SQLParamPlugin.class);
    private Resources resources;
    Map<String, String> cache;
    HashMap<ISQLPanelAPI, ISQLExecutionListener> panelListenerMap = new HashMap();

    public String getInternalName() {
        return "sqlparam";
    }

    public String getDescriptiveName() {
        return "SQL Parametrisation";
    }

    public String getVersion() {
        return "1.0.1";
    }

    public String getContributors() {
        return "";
    }

    public String getAuthor() {
        return "Thorsten M\u00fcrell";
    }

    public String getChangeLogFileName() {
        return "changes.txt";
    }

    public String getHelpFileName() {
        return "readme.html";
    }

    public String getLicenceFileName() {
        return "licence.txt";
    }

    public void initialize() throws PluginException {
        this.resources = new Resources((IPlugin)this);
    }

    public void unload() {
        for (Map.Entry<ISQLPanelAPI, ISQLExecutionListener> entry : this.panelListenerMap.entrySet()) {
            ISQLPanelAPI api = entry.getKey();
            ISQLExecutionListener listener = entry.getValue();
            this.removeSQLExecutionListener(api, listener);
        }
        this.panelListenerMap.clear();
    }

    public boolean allowsSessionStartedInBackground() {
        return true;
    }

    public void sessionCreated(ISession session) {
        this.cache = new Hashtable<String, String>();
    }

    public Map<String, String> getCache() {
        return this.cache;
    }

    public PluginSessionCallback sessionStarted(ISession session) {
        log.info((Object)"Initializing plugin");
        ISQLPanelAPI sqlPaneAPI = session.getSessionSheet().getSQLPaneAPI();
        this.initSQLParam(sqlPaneAPI, session);
        PluginSessionCallback ret = new PluginSessionCallback(){

            public void sqlInternalFrameOpened(SQLInternalFrame sqlInternalFrame, ISession sess) {
                SQLParamPlugin.this.initSQLParam(sqlInternalFrame.getSQLPanelAPI(), sess);
            }

            public void objectTreeInternalFrameOpened(ObjectTreeInternalFrame objectTreeInternalFrame, ISession sess) {
            }
        };
        return ret;
    }

    public void sessionEnding(ISession session) {
        ISQLPanelAPI sqlPaneAPI = session.getSessionSheet().getSQLPaneAPI();
        ISQLExecutionListener listener = this.panelListenerMap.remove(sqlPaneAPI);
        this.removeSQLExecutionListener(sqlPaneAPI, listener);
    }

    private void removeSQLExecutionListener(ISQLPanelAPI api, ISQLExecutionListener listener) {
        if (api != null && listener != null) {
            api.removeSQLExecutionListener(listener);
        }
    }

    private void initSQLParam(final ISQLPanelAPI sqlPaneAPI, final ISession session) {
        final SQLParamPlugin plugin = this;
        GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

            @Override
            public void run() {
                log.info((Object)"Adding SQL execution listener.");
                SQLParamExecutionListener listener = new SQLParamExecutionListener(plugin, session);
                sqlPaneAPI.addSQLExecutionListener((ISQLExecutionListener)listener);
                SQLParamPlugin.this.panelListenerMap.put(sqlPaneAPI, (ISQLExecutionListener)listener);
            }
        });
    }

    public PluginResources getResources() {
        return this.resources;
    }
}

