/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.sqlreplace;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import net.sourceforge.squirrel_sql.fw.util.IMessageHandler;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanReader;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanWriter;
import net.sourceforge.squirrel_sql.fw.xml.XMLException;
import net.sourceforge.squirrel_sql.plugins.sqlreplace.Replacement;
import net.sourceforge.squirrel_sql.plugins.sqlreplace.SQLReplacePlugin;

public class ReplacementManager {
    private File replacementFile;
    private ArrayList<Replacement> replacements = new ArrayList();
    IMessageHandler mpan;
    private static final ILogger log = LoggerController.createLogger(SQLReplacePlugin.class);

    public ReplacementManager(SQLReplacePlugin _plugin) {
        try {
            this.replacementFile = new File(_plugin.getPluginUserSettingsFolder(), "sqlreplacement.xml");
            this.mpan = _plugin.getApplication().getMessageHandler();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void load() throws IOException {
        this.replacements.clear();
        try {
            XMLBeanReader xmlin = new XMLBeanReader();
            if (this.replacementFile.exists()) {
                xmlin.load(this.replacementFile, this.getClass().getClassLoader());
                for (Object bean : xmlin) {
                    if (!(bean instanceof Replacement)) continue;
                    this.replacements.add((Replacement)bean);
                }
            }
        }
        catch (XMLException e) {
            throw new RuntimeException(e);
        }
    }

    protected void save() {
        try {
            XMLBeanWriter xmlout = new XMLBeanWriter();
            for (Replacement rep : this.replacements) {
                xmlout.addToRoot((Object)rep);
            }
            xmlout.save(this.replacementFile);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Iterator<Replacement> iterator() {
        return this.replacements.iterator();
    }

    public void removeAll() {
        this.replacements = new ArrayList();
    }

    public void setContentFromEditor(String content) {
        String cont = content;
        String[] lines = cont.split("\n");
        this.replacements.clear();
        for (String line : lines) {
            String[] s;
            if (line == null || line.length() == 0 || (s = line.split("="))[0] == null || s[0].length() <= 0 || s[1] == null || s[1].length() <= 0) continue;
            Replacement ro = new Replacement(s[0].trim(), s[1].trim());
            this.replacements.add(ro);
        }
        this.save();
    }

    public String getContent() {
        StringBuilder sb = new StringBuilder();
        for (Replacement r : this.replacements) {
            sb.append(r.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    public String replace(StringBuffer buffer) {
        String toReplace = buffer.toString();
        for (Replacement r : this.replacements) {
            if (toReplace.indexOf(r.getVariable()) <= -1) continue;
            String replacementMsg = "Replace-Rule: " + r.toString();
            if (log.isInfoEnabled()) {
                log.info((Object)replacementMsg);
            }
            this.mpan.showMessage(replacementMsg);
            toReplace = toReplace.replace(r.getVariable(), r.getValue());
        }
        return toReplace;
    }
}

