/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.sqlscript.table_script;

import java.awt.Frame;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.NumberFormat;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.gui.IAbortEventHandler;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.codereformat.CodeReformator;
import net.sourceforge.squirrel_sql.fw.codereformat.CommentSpec;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.fw.gui.action.ResultSetExportCommand;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.ProgressAbortCallback;
import net.sourceforge.squirrel_sql.fw.sql.ProgressAbortFactoryCallback;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.plugins.sqlscript.SQLScriptPlugin;
import net.sourceforge.squirrel_sql.plugins.sqlscript.table_script.AbstractDataScriptCommand;
import net.sourceforge.squirrel_sql.plugins.sqlscript.table_script.SQL2FileProgressAbortDialog;
import org.apache.commons.lang.time.StopWatch;

public class CreateFileOfCurrentSQLCommand
extends AbstractDataScriptCommand {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(CreateFileOfCurrentSQLCommand.class);
    private ResultSetExportCommand resultSetExportCommand;
    private Statement stmt = null;
    private ProgressAbortCallback progressDialog;
    private String currentSQL = null;

    public CreateFileOfCurrentSQLCommand(ISession session, SQLScriptPlugin plugin) {
        super(session, plugin);
    }

    public void execute() {
        this.currentSQL = this.getSelectedSelectStatement();
        this.getSession().getApplication().getThreadPool().addTask(new Runnable(){

            @Override
            public void run() {
                CreateFileOfCurrentSQLCommand.this.doCreateFileOfCurrentSQL();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void doCreateFileOfCurrentSQL() {
        block14: {
            StopWatch stopWatch;
            ISQLConnection unmanagedConnection;
            block12: {
                block13: {
                    unmanagedConnection = null;
                    unmanagedConnection = this.createUnmanagedConnection();
                    this.stmt = unmanagedConnection != null ? this.createStatementForStreamingResults(unmanagedConnection.getConnection()) : this.createStatementForStreamingResults(this.getSession().getSQLConnection().getConnection());
                    ProgressAbortFactoryCallback progressFactory = new ProgressAbortFactoryCallback(){

                        public ProgressAbortCallback create() {
                            CreateFileOfCurrentSQLCommand.this.createProgressAbortDialog();
                            return CreateFileOfCurrentSQLCommand.this.progressDialog;
                        }
                    };
                    stopWatch = new StopWatch();
                    stopWatch.start();
                    DialectType dialectType = DialectFactory.getDialectType((ISQLDatabaseMetaData)this.getSession().getMetaData());
                    this.resultSetExportCommand = new ResultSetExportCommand(this.stmt, this.currentSQL, dialectType, progressFactory);
                    this.resultSetExportCommand.execute();
                    stopWatch.stop();
                    if (!this.isAborted()) break block12;
                    SQLUtilities.closeStatement((Statement)this.stmt);
                    if (unmanagedConnection == null) break block13;
                    unmanagedConnection.close();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CreateFileOfCurrentSQLCommand.this.hideProgressMonitor();
                    }
                });
                return;
            }
            try {
                if (this.resultSetExportCommand.getWrittenRows() >= 0L) {
                    NumberFormat nf = NumberFormat.getIntegerInstance();
                    String rows = nf.format(this.resultSetExportCommand.getWrittenRows());
                    File targetFile = this.resultSetExportCommand.getTargetFile();
                    String seconds = nf.format(stopWatch.getTime() / 1000L);
                    String msg = s_stringMgr.getString("CreateFileOfCurrentSQLCommand.progress.sucessMessage", new Object[]{rows, targetFile, seconds});
                    this.getSession().showMessage(msg);
                }
                break block14;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                finally {
                    SQLUtilities.closeStatement((Statement)this.stmt);
                    if (unmanagedConnection != null) {
                        unmanagedConnection.close();
                    }
                }
            }
            catch (Exception e) {
                try {
                    if (e.getCause() != null) {
                        this.getSession().showErrorMessage(e.getCause());
                    }
                    this.getSession().showErrorMessage(e.getMessage());
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    private Statement createStatementForStreamingResults(Connection connection) throws SQLException {
        Statement stmt;
        DialectType dialectType = DialectFactory.getDialectType((ISQLDatabaseMetaData)this.getSession().getMetaData());
        if (DialectType.MYSQL5 == dialectType) {
            stmt = connection.createStatement(1003, 1007);
            stmt.setFetchSize(Integer.MIN_VALUE);
        } else {
            stmt = connection.createStatement();
        }
        return stmt;
    }

    private ISQLConnection createUnmanagedConnection() throws SQLException {
        SQLConnection unmanagedConnection = this.getSession().createUnmanagedConnection();
        if (unmanagedConnection == null) {
            int option = JOptionPane.showConfirmDialog(null, "Unable to open a new connection. The current connection will be used instead.", "Unable to open a new Connection", 2);
            if (option == 2) {
                return null;
            }
        } else {
            unmanagedConnection.setAutoCommit(false);
        }
        return unmanagedConnection;
    }

    protected void createProgressAbortDialog() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    CommentSpec[] commentSpecs = new CommentSpec[]{new CommentSpec("/*", "*/"), new CommentSpec("--", StringUtilities.getEolStr())};
                    String statementSep = CreateFileOfCurrentSQLCommand.this.getSession().getQueryTokenizer().getSQLStatementSeparator();
                    CodeReformator cr = new CodeReformator(statementSep, commentSpecs);
                    String reformatedSQL = cr.reformat(CreateFileOfCurrentSQLCommand.this.resultSetExportCommand.getSql());
                    String targetFile = CreateFileOfCurrentSQLCommand.this.resultSetExportCommand.getTargetFile().getAbsolutePath();
                    String title = s_stringMgr.getString("CreateFileOfCurrentSQLCommand.progress.title", new Object[]{targetFile});
                    CreateFileOfCurrentSQLCommand.this.progressDialog = (ProgressAbortCallback)new SQL2FileProgressAbortDialog((Frame)null, title, targetFile, reformatedSQL, new IAbortEventHandler(){

                        public void cancel() {
                            if (CreateFileOfCurrentSQLCommand.this.stmt != null) {
                                try {
                                    CreateFileOfCurrentSQLCommand.this.stmt.cancel();
                                }
                                catch (SQLException sQLException) {
                                    // empty catch block
                                }
                            }
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create the Progress Monitor.", e);
        }
    }

    protected void hideProgressMonitor() {
        if (this.progressDialog != null) {
            this.progressDialog.setVisible(false);
            this.progressDialog.dispose();
        }
    }

    protected boolean isAborted() {
        return this.progressDialog != null && this.progressDialog.isStop();
    }
}

