/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.sqlscript.table_script;

import java.awt.event.WindowAdapter;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.JDBCTypeMapper;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import net.sourceforge.squirrel_sql.fw.util.ICommand;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.sqlscript.FrameWorkAcessor;
import net.sourceforge.squirrel_sql.plugins.sqlscript.SQLScriptPlugin;
import net.sourceforge.squirrel_sql.plugins.sqlscript.table_script.AbortController;
import net.sourceforge.squirrel_sql.plugins.sqlscript.table_script.ScriptUtil;

public class CreateDataScriptCommand
extends WindowAdapter
implements ICommand {
    private static final ILogger s_log = LoggerController.createLogger(CreateDataScriptCommand.class);
    private Boolean dialectSupportsSubSecondTimestamps = null;
    protected AbortController _abortController;
    protected ISession _session;
    private final SQLScriptPlugin _plugin;
    private boolean _templateScriptOnly;

    public CreateDataScriptCommand(ISession session, SQLScriptPlugin plugin, boolean templateScriptOnly) {
        this._session = session;
        this._plugin = plugin;
        this._templateScriptOnly = templateScriptOnly;
        this._abortController = new AbortController(this._session.getApplication());
    }

    protected void showAbortFrame() {
        if (!this._abortController.isVisble()) {
            this._abortController.setVisible(true);
        }
    }

    public void execute() {
        final StringBuffer sbRows = new StringBuffer(1000);
        this._session.getApplication().getThreadPool().addTask(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ISQLConnection conn = CreateDataScriptCommand.this._session.getSQLConnection();
                try {
                    Statement stmt = conn.createStatement();
                    try {
                        IObjectTreeAPI api = FrameWorkAcessor.getObjectTreeAPI(CreateDataScriptCommand.this._session, CreateDataScriptCommand.this._plugin);
                        IDatabaseObjectInfo[] dbObjs = api.getSelectedDatabaseObjects();
                        for (int k = 0; k < dbObjs.length; ++k) {
                            if (!(dbObjs[k] instanceof ITableInfo)) continue;
                            if (CreateDataScriptCommand.this._abortController.isStop()) {
                                break;
                            }
                            ITableInfo ti = (ITableInfo)dbObjs[k];
                            String sTable = ScriptUtil.getTableName(ti);
                            StringBuilder sql = new StringBuilder();
                            sql.append("select * from ");
                            sql.append(ti.getQualifiedName());
                            if (!JDBCTypeMapper.isLongType((int)CreateDataScriptCommand.this.getFirstColumnType(ti))) {
                                sql.append(" order by ");
                                sql.append(CreateDataScriptCommand.this.getFirstColumnName(ti));
                                sql.append(" asc ");
                            }
                            if (s_log.isDebugEnabled()) {
                                s_log.debug((Object)("execute: generating insert statements from data retrieved with SQL = " + sql.toString()));
                            }
                            ResultSet srcResult = stmt.executeQuery(sql.toString());
                            CreateDataScriptCommand.this.genInserts(srcResult, sTable, sbRows, false);
                        }
                    }
                    finally {
                        SQLUtilities.closeStatement((Statement)stmt);
                    }
                }
                catch (Exception e) {
                    CreateDataScriptCommand.this._session.showErrorMessage((Throwable)e);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (sbRows.length() > 0) {
                            FrameWorkAcessor.getSQLPanelAPI(CreateDataScriptCommand.this._session, CreateDataScriptCommand.this._plugin).appendSQLScript(sbRows.toString(), true);
                            CreateDataScriptCommand.this._session.selectMainTab(1);
                        }
                        CreateDataScriptCommand.this._abortController.setVisible(false);
                    }
                });
            }
        });
        this.showAbortFrame();
    }

    protected String getFirstColumnName(ITableInfo ti) throws SQLException {
        TableColumnInfo[] infos = this._session.getSQLConnection().getSQLMetaData().getColumnInfo(ti);
        return infos[0].getColumnName();
    }

    protected int getFirstColumnType(ITableInfo ti) throws SQLException {
        TableColumnInfo[] infos = this._session.getSQLConnection().getSQLMetaData().getColumnInfo(ti);
        return infos[0].getDataType();
    }

    protected void genInserts(ResultSet srcResult, String sTable, StringBuffer sbRows, boolean headerOnly) throws SQLException {
        ResultSetMetaData metaData = srcResult.getMetaData();
        int iColumnCount = metaData.getColumnCount();
        ColumnInfo[] colInfo = new ColumnInfo[iColumnCount];
        for (int i = 1; i <= iColumnCount; ++i) {
            colInfo[i - 1] = new ColumnInfo(metaData.getColumnName(i), metaData.getColumnType(i));
        }
        boolean fromResultSet = !this._templateScriptOnly && !headerOnly;
        sbRows.append("\n\n");
        Timestamp currentTime = new Timestamp(System.currentTimeMillis());
        while ((srcResult.next() || this._templateScriptOnly || headerOnly) && !this.isAborted()) {
            sbRows.append("INSERT INTO ");
            StringBuffer sbValues = new StringBuffer();
            sbRows.append(sTable);
            sbRows.append(" (");
            sbValues.append(" VALUES (");
            ScriptUtil su = new ScriptUtil();
            for (int i = 0; i < iColumnCount; ++i) {
                int iIndexPoint = colInfo[i].columnName.lastIndexOf(46);
                sbRows.append(su.makeColumnNameUnique(colInfo[i].columnName.substring(iIndexPoint + 1)));
                if (-6 == colInfo[i].sqlType || -5 == colInfo[i].sqlType || 5 == colInfo[i].sqlType || 4 == colInfo[i].sqlType || 6 == colInfo[i].sqlType || 7 == colInfo[i].sqlType || 8 == colInfo[i].sqlType || 2 == colInfo[i].sqlType || 3 == colInfo[i].sqlType) {
                    Object value = fromResultSet ? srcResult.getObject(i + 1) : "0" + this.getNullableComment(metaData, i + 1);
                    sbValues.append(value);
                } else if (91 == colInfo[i].sqlType || 92 == colInfo[i].sqlType || 93 == colInfo[i].sqlType) {
                    Calendar calendar = Calendar.getInstance();
                    Timestamp timestamp = null;
                    if (91 == colInfo[i].sqlType) {
                        timestamp = fromResultSet ? srcResult.getDate(i + 1) : currentTime;
                    } else if (92 == colInfo[i].sqlType) {
                        timestamp = fromResultSet ? srcResult.getTime(i + 1) : currentTime;
                    } else if (93 == colInfo[i].sqlType) {
                        Timestamp timestamp2 = timestamp = fromResultSet ? srcResult.getTimestamp(i + 1) : currentTime;
                    }
                    if (timestamp == null) {
                        sbValues.append("null");
                    } else {
                        calendar.setTime(timestamp);
                        if (91 == colInfo[i].sqlType) {
                            String esc = "{d '" + this.prefixNulls(calendar.get(1), 4) + "-" + this.prefixNulls(calendar.get(2) + 1, 2) + "-" + this.prefixNulls(calendar.get(5), 2) + "'}";
                            esc = fromResultSet ? esc : esc + this.getNullableComment(metaData, i + 1);
                            sbValues.append(esc);
                        } else if (92 == colInfo[i].sqlType) {
                            String esc = "{t '" + this.prefixNulls(calendar.get(11), 2) + ":" + this.prefixNulls(calendar.get(12), 2) + ":" + this.prefixNulls(calendar.get(13), 2) + "'}";
                            esc = fromResultSet ? esc : esc + this.getNullableComment(metaData, i + 1);
                            sbValues.append(esc);
                        } else if (93 == colInfo[i].sqlType) {
                            Timestamp ts = timestamp;
                            StringBuilder esc = new StringBuilder("{ts '");
                            esc.append(this.prefixNulls(calendar.get(1), 4)).append("-");
                            esc.append(this.prefixNulls(calendar.get(2) + 1, 2)).append("-");
                            esc.append(this.prefixNulls(calendar.get(5), 2)).append(" ");
                            esc.append(this.prefixNulls(calendar.get(11), 2)).append(":");
                            esc.append(this.prefixNulls(calendar.get(12), 2)).append(":");
                            esc.append(this.prefixNulls(calendar.get(13), 2)).append(".");
                            esc.append(this.getNanos(ts));
                            esc.append("'}");
                            if (!fromResultSet) {
                                esc.append(this.getNullableComment(metaData, i + 1));
                            }
                            sbValues.append((CharSequence)esc);
                        }
                    }
                } else if (-7 == colInfo[i].sqlType || 16 == colInfo[i].sqlType) {
                    boolean iBoolean;
                    boolean bl = iBoolean = fromResultSet ? srcResult.getBoolean(i + 1) : false;
                    if (fromResultSet && srcResult.wasNull()) {
                        sbValues.append("null");
                    } else if (iBoolean) {
                        if (DialectFactory.isPostgreSQL((ISQLDatabaseMetaData)this._session.getMetaData())) {
                            sbValues.append("true");
                        } else {
                            sbValues.append(1);
                        }
                    } else if (DialectFactory.isPostgreSQL((ISQLDatabaseMetaData)this._session.getMetaData())) {
                        sbValues.append("false");
                    } else {
                        sbValues.append(0);
                    }
                    if (!fromResultSet) {
                        sbValues.append(this.getNullableComment(metaData, i + 1));
                    }
                } else {
                    String sResult;
                    String string = sResult = fromResultSet ? srcResult.getString(i + 1) : "s";
                    if (sResult == null) {
                        sbValues.append("null");
                    } else {
                        StringBuffer sb;
                        int iIndex = sResult.indexOf("'");
                        if (iIndex != -1) {
                            int iPrev = 0;
                            sb = new StringBuffer();
                            sb.append(sResult.substring(iPrev, iIndex));
                            sb.append('\'');
                            iPrev = iIndex;
                            iIndex = sResult.indexOf("'", iPrev + 1);
                            while (iIndex != -1) {
                                sb.append(sResult.substring(iPrev, iIndex));
                                sb.append('\'');
                                iPrev = iIndex;
                                iIndex = sResult.indexOf("'", iPrev + 1);
                            }
                            sb.append(sResult.substring(iPrev));
                            sResult = sb.toString();
                        }
                        if ((iIndex = sResult.indexOf(10)) != -1) {
                            int iPrev = 0;
                            sb = new StringBuffer();
                            sb.append(sResult.substring(iPrev, iIndex));
                            sb.append("\\n");
                            iPrev = iIndex + 1;
                            iIndex = sResult.indexOf(10, iPrev + 1);
                            while (iIndex != -1) {
                                sb.append(sResult.substring(iPrev, iIndex));
                                sb.append("\\n");
                                iPrev = iIndex + 1;
                                iIndex = sResult.indexOf(10, iPrev + 1);
                            }
                            sb.append(sResult.substring(iPrev));
                            sResult = sb.toString();
                        }
                        sbValues.append("'");
                        sbValues.append(sResult);
                        sbValues.append("'");
                        if (!fromResultSet) {
                            sbValues.append(this.getNullableComment(metaData, i + 1));
                        }
                    }
                }
                sbValues.append(",");
                sbRows.append(",");
            }
            sbValues.setLength(sbValues.length() - 1);
            sbRows.setLength(sbRows.length() - 1);
            sbValues.append(")").append(this.getStatementSeparator()).append("\n");
            sbRows.append(")");
            if (!headerOnly) {
                sbRows.append(sbValues.toString());
            }
            if (!this._templateScriptOnly && !headerOnly) continue;
            break;
        }
        srcResult.close();
    }

    private String getNanos(Timestamp ts) throws SQLException {
        ISQLDatabaseMetaData md = this._session.getMetaData();
        HibernateDialect dialect = DialectFactory.getDialect((ISQLDatabaseMetaData)md);
        boolean dialectSupportsSubSecondTimestamps = this.getTimestampFlag();
        if (!dialectSupportsSubSecondTimestamps || dialect.getTimestampMaximumFractionalDigits() == 0) {
            return "";
        }
        String result = "" + ts.getNanos();
        result = result.substring(0, dialect.getTimestampMaximumFractionalDigits());
        return result;
    }

    private boolean getTimestampFlag() throws SQLException {
        if (this.dialectSupportsSubSecondTimestamps == null) {
            ISQLDatabaseMetaData md = this._session.getMetaData();
            HibernateDialect dialect = DialectFactory.getDialect((ISQLDatabaseMetaData)md);
            this.dialectSupportsSubSecondTimestamps = dialect.supportsSubSecondTimestamps();
        }
        return this.dialectSupportsSubSecondTimestamps;
    }

    private String getNullableComment(ResultSetMetaData metaData, int colIndex) throws SQLException {
        if (0 == metaData.isNullable(colIndex)) {
            return " /*not nullable*/";
        }
        return "";
    }

    private String prefixNulls(int toPrefix, int digitCount) {
        String ret = "" + toPrefix;
        while (ret.length() < digitCount) {
            ret = 0 + ret;
        }
        return ret;
    }

    private String getStatementSeparator() {
        String statementSeparator = this._session.getQueryTokenizer().getSQLStatementSeparator();
        if (1 < statementSeparator.length()) {
            statementSeparator = "\n" + statementSeparator + "\n";
        }
        return statementSeparator;
    }

    protected void hideAbortFrame() {
        this._abortController.setVisible(false);
    }

    protected boolean isAborted() {
        return this._abortController.isStop();
    }

    private static class ColumnInfo {
        int sqlType;
        String columnName;

        public ColumnInfo(String columnName, int sqlType) {
            this.columnName = columnName;
            this.sqlType = sqlType;
        }
    }
}

