package net.sourceforge.squirrel_sql.plugins.db2.exp;
/*
 * Copyright (C) 2007 Rob Manning
 * manningr@users.sourceforge.net
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
import java.util.ArrayList;
import java.util.List;

import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeNode;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaData;

/**
 * This class is an expander for the schema nodes. It will add Sequence and UDF Object 
 * Type nodes to the schema node.
 *
 * @author manningr
 */
public class SchemaExpander implements INodeExpander
{

    /** whether or not we are connected to OS/400 */
    private boolean isOS400 = false;
    
	/**
	 * Ctor.
	 */
	public SchemaExpander(boolean isOS400)
	{
		super();
		this.isOS400 = isOS400;
	}

	/**
	 * Create the child nodes for the passed parent node and return them. Note
	 * that this method should <B>not</B> actually add the child nodes to the
	 * parent node as this is taken care of in the caller.
	 *
	 * @param	session	Current session.
	 * @param	node	Node to be expanded.
	 *
	 * @return	A list of <TT>ObjectTreeNode</TT> objects representing the child
	 *			nodes for the passed node.
	 */
	public List<ObjectTreeNode> createChildren(ISession session, ObjectTreeNode parentNode)
	{
		final List<ObjectTreeNode> childNodes = new ArrayList<ObjectTreeNode>();
		final IDatabaseObjectInfo parentDbinfo = parentNode.getDatabaseObjectInfo();
		final SQLDatabaseMetaData md = session.getSQLConnection().getSQLMetaData();
		final String catalogName = parentDbinfo.getCatalogName();
		final String schemaName = parentDbinfo.getSimpleName();

        IDatabaseObjectInfo seqInfo = 
            new DatabaseObjectInfo(catalogName,
                                   schemaName, 
                                   "SEQUENCE",
                                   DatabaseObjectType.SEQUENCE_TYPE_DBO, 
                                   md);
        ObjectTreeNode node = new ObjectTreeNode(session, seqInfo);
        node.addExpander(new SequenceParentExpander(isOS400));
        childNodes.add(node);

        IDatabaseObjectInfo udfInfo = 
            new DatabaseObjectInfo(catalogName,
                                   schemaName, 
                                   "UDF",
                                   DatabaseObjectType.UDF_TYPE_DBO, 
                                   md);
        ObjectTreeNode udfnode = new ObjectTreeNode(session, udfInfo);
        udfnode.addExpander(new UDFParentExpander(isOS400));
        childNodes.add(udfnode);
        
        
		return childNodes;
	}

}
