/*
 * Decompiled with CFR 0.152.
 */
package xapi.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import xapi.bytecode.ConstInfo;
import xapi.bytecode.ConstPool;

class DoubleInfo
extends ConstInfo {
    static final int tag = 6;
    double value;

    public DoubleInfo(double d) {
        this.value = d;
    }

    public DoubleInfo(DataInput in) throws IOException {
        this.value = in.readDouble();
    }

    @Override
    public int getTag() {
        return 6;
    }

    @Override
    public int copy(ConstPool src, ConstPool dest, Map<?, ?> map) {
        return dest.addDoubleInfo(this.value);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(6);
        out.writeDouble(this.value);
    }

    @Override
    public void print(PrintWriter out) {
        out.print("Double ");
        out.println(this.value);
    }
}

