/*
 * Decompiled with CFR 0.152.
 */
package xapi.bytecode.attributes;

import java.io.DataInput;
import java.io.IOException;
import java.util.Map;
import xapi.bytecode.ConstPool;
import xapi.bytecode.attributes.AttributeInfo;
import xapi.util.X_Byte;

public class InnerClassesAttribute
extends AttributeInfo {
    public static final String tag = "InnerClasses";

    InnerClassesAttribute(ConstPool cp, int n, DataInput in) throws IOException {
        super(cp, n, in);
    }

    private InnerClassesAttribute(ConstPool cp, byte[] info) {
        super(cp, tag, info);
    }

    public InnerClassesAttribute(ConstPool cp) {
        super(cp, tag, new byte[2]);
        X_Byte.write16bit((int)0, (byte[])this.get(), (int)0);
    }

    public int tableLength() {
        return X_Byte.readU16bit((byte[])this.get(), (int)0);
    }

    public int innerClassIndex(int nth) {
        return X_Byte.readU16bit((byte[])this.get(), (int)(nth * 8 + 2));
    }

    public String innerClass(int nth) {
        int i = this.innerClassIndex(nth);
        if (i == 0) {
            return null;
        }
        return this.constPool.getClassInfo(i);
    }

    public void setInnerClassIndex(int nth, int index) {
        X_Byte.write16bit((int)index, (byte[])this.get(), (int)(nth * 8 + 2));
    }

    public int outerClassIndex(int nth) {
        return X_Byte.readU16bit((byte[])this.get(), (int)(nth * 8 + 4));
    }

    public String outerClass(int nth) {
        int i = this.outerClassIndex(nth);
        if (i == 0) {
            return null;
        }
        return this.constPool.getClassInfo(i);
    }

    public void setOuterClassIndex(int nth, int index) {
        X_Byte.write16bit((int)index, (byte[])this.get(), (int)(nth * 8 + 4));
    }

    public int innerNameIndex(int nth) {
        return X_Byte.readU16bit((byte[])this.get(), (int)(nth * 8 + 6));
    }

    public String innerName(int nth) {
        int i = this.innerNameIndex(nth);
        if (i == 0) {
            return null;
        }
        return this.constPool.getUtf8Info(i);
    }

    public void setInnerNameIndex(int nth, int index) {
        X_Byte.write16bit((int)index, (byte[])this.get(), (int)(nth * 8 + 6));
    }

    public int accessFlags(int nth) {
        return X_Byte.readU16bit((byte[])this.get(), (int)(nth * 8 + 8));
    }

    public void setAccessFlags(int nth, int flags) {
        X_Byte.write16bit((int)flags, (byte[])this.get(), (int)(nth * 8 + 8));
    }

    public void append(String inner, String outer, String name, int flags) {
        int i = this.constPool.addClassInfo(inner);
        int o = this.constPool.addClassInfo(outer);
        int n = this.constPool.addUtf8Info(name);
        this.append(i, o, n, flags);
    }

    public void append(int inner, int outer, int name, int flags) {
        byte[] data = this.get();
        int len = data.length;
        byte[] newData = new byte[len + 8];
        for (int i = 2; i < len; ++i) {
            newData[i] = data[i];
        }
        int n = X_Byte.readU16bit((byte[])data, (int)0);
        X_Byte.write16bit((int)(n + 1), (byte[])newData, (int)0);
        X_Byte.write16bit((int)inner, (byte[])newData, (int)len);
        X_Byte.write16bit((int)outer, (byte[])newData, (int)(len + 2));
        X_Byte.write16bit((int)name, (byte[])newData, (int)(len + 4));
        X_Byte.write16bit((int)flags, (byte[])newData, (int)(len + 6));
        this.set(newData);
    }

    @Override
    public AttributeInfo copy(ConstPool newCp, Map<?, ?> classnames) {
        byte[] src = this.get();
        byte[] dest = new byte[src.length];
        ConstPool cp = this.getConstPool();
        InnerClassesAttribute attr = new InnerClassesAttribute(newCp, dest);
        int n = X_Byte.readU16bit((byte[])src, (int)0);
        X_Byte.write16bit((int)n, (byte[])dest, (int)0);
        int j = 2;
        for (int i = 0; i < n; ++i) {
            int innerClass = X_Byte.readU16bit((byte[])src, (int)j);
            int outerClass = X_Byte.readU16bit((byte[])src, (int)(j + 2));
            int innerName = X_Byte.readU16bit((byte[])src, (int)(j + 4));
            int innerAccess = X_Byte.readU16bit((byte[])src, (int)(j + 6));
            if (innerClass != 0) {
                innerClass = cp.copy(innerClass, newCp, classnames);
            }
            X_Byte.write16bit((int)innerClass, (byte[])dest, (int)j);
            if (outerClass != 0) {
                outerClass = cp.copy(outerClass, newCp, classnames);
            }
            X_Byte.write16bit((int)outerClass, (byte[])dest, (int)(j + 2));
            if (innerName != 0) {
                innerName = cp.copy(innerName, newCp, classnames);
            }
            X_Byte.write16bit((int)innerName, (byte[])dest, (int)(j + 4));
            X_Byte.write16bit((int)innerAccess, (byte[])dest, (int)(j + 6));
            j += 8;
        }
        return attr;
    }
}

