/*
 * Decompiled with CFR 0.152.
 */
package xapi.bytecode.impl;

import java.lang.reflect.Array;
import java.util.Arrays;
import xapi.bytecode.annotation.Annotation;
import xapi.bytecode.annotation.AnnotationMemberValue;
import xapi.bytecode.annotation.AnnotationsAttribute;
import xapi.bytecode.annotation.ArrayMemberValue;
import xapi.bytecode.annotation.BooleanMemberValue;
import xapi.bytecode.annotation.ByteMemberValue;
import xapi.bytecode.annotation.CharMemberValue;
import xapi.bytecode.annotation.ClassMemberValue;
import xapi.bytecode.annotation.DoubleMemberValue;
import xapi.bytecode.annotation.EnumMemberValue;
import xapi.bytecode.annotation.FloatMemberValue;
import xapi.bytecode.annotation.IntegerMemberValue;
import xapi.bytecode.annotation.LongMemberValue;
import xapi.bytecode.annotation.MemberValue;
import xapi.bytecode.annotation.MemberValueVisitor;
import xapi.bytecode.annotation.ShortMemberValue;
import xapi.bytecode.annotation.StringMemberValue;
import xapi.bytecode.impl.BytecodeAdapterService;
import xapi.collect.impl.ToStringFifo;
import xapi.log.X_Log;
import xapi.source.X_Modifier;
import xapi.source.api.IsAnnotationValue;
import xapi.source.api.IsClass;
import xapi.source.api.IsType;
import xapi.source.impl.ImmutableAnnotationValue;
import xapi.util.X_Debug;
import xapi.util.api.ConvertsValue;

public class BytecodeUtil {
    public static Annotation[] extractAnnotations(AnnotationsAttribute visible, AnnotationsAttribute invisible) {
        Annotation[] invis;
        Annotation[] vis = visible == null ? null : visible.getAnnotations();
        Annotation[] annotationArray = invis = invisible == null ? null : invisible.getAnnotations();
        if (vis == null) {
            return invis == null ? new Annotation[]{} : invis;
        }
        if (invis == null) {
            return vis;
        }
        vis = Arrays.copyOf(vis, vis.length + invis.length);
        System.arraycopy(invis, 0, vis, vis.length - invis.length, invis.length);
        return vis;
    }

    public static IsAnnotationValue extractValue(MemberValue value, BytecodeAdapterService service, IsType type) {
        return new ValueExtractor().extract(value, service, type);
    }

    private static final class ValueExtractor
    implements MemberValueVisitor {
        IsAnnotationValue value;
        private BytecodeAdapterService service;
        private IsType knownType;

        private ValueExtractor() {
        }

        public IsAnnotationValue extract(MemberValue member, BytecodeAdapterService service, IsType type) {
            this.service = service;
            this.knownType = type;
            member.accept(this);
            return this.value;
        }

        @Override
        public void visitAnnotationMemberValue(AnnotationMemberValue node) {
            final Annotation val = node.getValue();
            this.value = new ImmutableAnnotationValue(val.getTypeName(), (Object)this.service.toAnnotation(val), (ConvertsValue)new ConvertsValue<Object, String>(){

                public String convert(Object from) {
                    return val.toString();
                }
            }, 8192);
        }

        @Override
        public void visitArrayMemberValue(ArrayMemberValue node) {
            MemberValue[] val = node.getValue();
            ToStringFifo toString = new ToStringFifo();
            ValueExtractor extract = new ValueExtractor();
            MemberValue type = node.getType();
            if (type == null) {
                try {
                    node.getType(this.service.getClassLoader());
                }
                catch (ClassNotFoundException e) {
                    if (val.length == 0 && this.knownType != null) {
                        Object value;
                        IsClass cls = this.service.toClass(this.knownType.getQualifiedName());
                        ConvertsValue<Object, String> toStringer = new ConvertsValue<Object, String>(){

                            public String convert(Object from) {
                                return "{}";
                            }
                        };
                        int modifier = 0;
                        if (cls.isPrimitive()) {
                            modifier = -1;
                            switch (cls.getQualifiedName()) {
                                case "boolean": {
                                    value = new boolean[0];
                                    break;
                                }
                                case "byte": {
                                    value = new byte[0];
                                    break;
                                }
                                case "char": {
                                    value = new char[0];
                                    break;
                                }
                                case "short": {
                                    value = new short[0];
                                    break;
                                }
                                case "int": {
                                    value = new int[0];
                                    break;
                                }
                                case "long": {
                                    value = new long[0];
                                    break;
                                }
                                case "float": {
                                    value = new float[0];
                                    break;
                                }
                                case "double": {
                                    value = new double[0];
                                    break;
                                }
                                default: {
                                    throw new IllegalArgumentException();
                                }
                            }
                        } else if (X_Modifier.isEnum((int)cls.getModifier())) {
                            modifier = 16384;
                            try {
                                Class clazz = cls.toClass(this.service.getClassLoader());
                                value = Array.newInstance(clazz, 0);
                            }
                            catch (ClassNotFoundException e1) {
                                throw X_Debug.rethrow((Throwable)e1);
                            }
                        } else if (X_Modifier.isAnnotation((int)cls.getModifier())) {
                            modifier = 8192;
                            value = new Class[]{};
                            try {
                                Class clazz = cls.toClass(this.service.getClassLoader());
                                value = Array.newInstance(clazz, 0);
                            }
                            catch (ClassNotFoundException e1) {
                                throw X_Debug.rethrow((Throwable)e1);
                            }
                        } else {
                            value = cls.getQualifiedName().equals(String.class.getName()) ? new String[]{} : new Class[]{};
                        }
                        this.value = new ImmutableAnnotationValue(cls.getQualifiedName(), value, modifier);
                    } else {
                        X_Log.error((Object[])new Object[]{this.getClass(), "Unable to load array member value type", node, "from", this.value, e});
                    }
                    return;
                }
                type = node.getType();
            }
            MemberValue[] arr$ = val;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                MemberValue member;
                type = member = arr$[i$];
                toString.give((Object)extract.extract(type, this.service, null));
            }
            ArrayTypeExtractor getType = new ArrayTypeExtractor();
            type.accept(getType);
            this.value = new ImmutableAnnotationValue(getType.type, (Object)toString, getType.modifier);
        }

        @Override
        public void visitBooleanMemberValue(BooleanMemberValue node) {
            this.value = new ImmutableAnnotationValue("boolean", (Object)node.getValue(), -1);
        }

        @Override
        public void visitByteMemberValue(ByteMemberValue node) {
            this.value = new ImmutableAnnotationValue("byte", (Object)node.getValue(), -1);
        }

        @Override
        public void visitCharMemberValue(CharMemberValue node) {
            this.value = new ImmutableAnnotationValue("char", (Object)Character.valueOf(node.getValue()), -1);
        }

        @Override
        public void visitDoubleMemberValue(DoubleMemberValue node) {
            this.value = new ImmutableAnnotationValue("double", (Object)node.getValue(), -1);
        }

        @Override
        public void visitEnumMemberValue(EnumMemberValue node) {
            Object val;
            try {
                Class<?> enumCls = Class.forName(node.getType(), false, this.service.getClassLoader());
                val = Enum.valueOf((Class)Class.class.cast(enumCls), node.getValue());
            }
            catch (Exception e) {
                X_Log.error((Object[])new Object[]{"Unable to load enum value type " + node.getType() + "." + node.getValue(), e});
                val = node.getValue();
            }
            this.value = new ImmutableAnnotationValue(node.getType(), val, 16384);
        }

        @Override
        public void visitFloatMemberValue(FloatMemberValue node) {
            this.value = new ImmutableAnnotationValue("float", (Object)Float.valueOf(node.getValue()), -1);
        }

        @Override
        public void visitIntegerMemberValue(IntegerMemberValue node) {
            this.value = new ImmutableAnnotationValue("int", (Object)node.getValue(), -1);
        }

        @Override
        public void visitLongMemberValue(LongMemberValue node) {
            this.value = new ImmutableAnnotationValue("long", (Object)node.getValue(), -1);
        }

        @Override
        public void visitShortMemberValue(ShortMemberValue node) {
            this.value = new ImmutableAnnotationValue("short", (Object)node.getValue(), -1);
        }

        @Override
        public void visitStringMemberValue(StringMemberValue node) {
            this.value = new ImmutableAnnotationValue("java.lang.String", (Object)node.getValue(), 0);
        }

        @Override
        public void visitClassMemberValue(ClassMemberValue node) {
            Object cls;
            final String name = node.getValue();
            try {
                cls = Class.forName(name, false, this.service.getClassLoader());
            }
            catch (Exception e) {
                X_Log.error((Object[])new Object[]{"Unable to load annotation class value ", node.getValue()});
                cls = node.getValue();
            }
            this.value = new ImmutableAnnotationValue("java.lang.Class", cls, (ConvertsValue)new ConvertsValue<Object, String>(){

                public String convert(Object from) {
                    return name;
                }
            }, 0);
        }
    }

    private static final class ArrayTypeExtractor
    implements MemberValueVisitor {
        String type;
        int modifier;

        private ArrayTypeExtractor() {
        }

        @Override
        public void visitAnnotationMemberValue(AnnotationMemberValue node) {
            this.type = node.getValue().getTypeName();
            this.modifier = 8192;
        }

        @Override
        public void visitArrayMemberValue(ArrayMemberValue node) {
            throw new IllegalStateException("Array types cannot have array members");
        }

        @Override
        public void visitBooleanMemberValue(BooleanMemberValue node) {
            this.type = "boolean";
            this.modifier = -1;
        }

        @Override
        public void visitByteMemberValue(ByteMemberValue node) {
            this.type = "byte";
            this.modifier = -1;
        }

        @Override
        public void visitCharMemberValue(CharMemberValue node) {
            this.type = "char";
            this.modifier = -1;
        }

        @Override
        public void visitDoubleMemberValue(DoubleMemberValue node) {
            this.type = "double";
            this.modifier = -1;
        }

        @Override
        public void visitEnumMemberValue(EnumMemberValue node) {
            this.type = node.getType();
            this.modifier = 16384;
        }

        @Override
        public void visitFloatMemberValue(FloatMemberValue node) {
            this.type = "float";
            this.modifier = -1;
        }

        @Override
        public void visitIntegerMemberValue(IntegerMemberValue node) {
            this.type = "int";
            this.modifier = -1;
        }

        @Override
        public void visitLongMemberValue(LongMemberValue node) {
            this.type = "long";
            this.modifier = -1;
        }

        @Override
        public void visitShortMemberValue(ShortMemberValue node) {
            this.type = "short";
            this.modifier = -1;
        }

        @Override
        public void visitStringMemberValue(StringMemberValue node) {
            this.type = "java.lang.String";
        }

        @Override
        public void visitClassMemberValue(ClassMemberValue node) {
            this.type = "java.lang.Class";
        }
    }
}

