/*
 * Decompiled with CFR 0.152.
 */
package xapi.dev.source;

import xapi.collect.impl.StringStack;

public class CharBuffer {
    StringBuilder target;
    protected String indent = "";
    CharBufferStack head;
    CharBufferStack tail;
    CharBuffer next;

    public CharBuffer() {
        this(new StringBuilder());
    }

    public CharBuffer(String text) {
        this(new StringBuilder(text));
    }

    public CharBuffer(CharBuffer preamble) {
        this(new StringBuilder());
        this.head.setValue(preamble);
    }

    public CharBuffer(StringBuilder target) {
        this.target = target;
        this.tail = this.head = new CharBufferStack();
    }

    CharBuffer append(StringBuilder chars) {
        return this;
    }

    CharBuffer makeChild() {
        CharBuffer child = this.newChild();
        if (this.next != null) {
            this.next.next = child;
        }
        this.next = child;
        return child;
    }

    protected CharBuffer newChild() {
        return new CharBuffer();
    }

    protected CharBuffer newChild(StringBuilder from) {
        return new CharBuffer(from);
    }

    protected void onAppend() {
    }

    public CharBuffer append(Object obj) {
        this.onAppend();
        this.target.append(obj);
        return this;
    }

    public CharBuffer append(String str) {
        this.onAppend();
        this.target.append(str);
        return this;
    }

    public void addToBeginning(CharBuffer buffer) {
        assert (this.notContained(buffer)) : "Infinite recursion!";
        CharBufferStack newHead = new CharBufferStack();
        newHead.next = this.head;
        newHead.setValue(buffer);
        this.head = newHead;
    }

    public CharBuffer printAfter(String suffix) {
        CharBuffer buffer = this.newChild(new StringBuilder(suffix));
        this.addToEnd(buffer);
        return buffer;
    }

    public CharBuffer clear() {
        this.tail = this.head = new CharBufferStack();
        this.target.setLength(0);
        return this;
    }

    public void addToEnd(CharBuffer buffer) {
        assert (this.notContained(buffer)) : "Infinite recursion! On [" + buffer + "] in " + this;
        CharBufferStack newTail = new CharBufferStack();
        newTail.setValue(buffer);
        newTail.setPrefix(this.target.toString());
        this.target.setLength(0);
        this.tail.next = newTail;
        this.tail = newTail;
    }

    private boolean notContained(CharBuffer buffer) {
        if (buffer == this) {
            System.err.println("Trying to add a buffer to itself");
            return false;
        }
        StringStack next = this.head;
        while (next != null) {
            if (next.getValue() == buffer) {
                System.err.println("Trying to add a buffer that is already a child");
                return false;
            }
            next = next.next;
        }
        next = buffer.head;
        while (next != null) {
            if (next.getValue() == this) {
                System.err.println("Trying to add an ancestor to a child");
                return false;
            }
            next = next.next;
        }
        return true;
    }

    public String toString() {
        StringBuilder body = new StringBuilder();
        body.append(this.head);
        body.append(this.target.toString());
        return body.toString();
    }

    protected static final class CharBufferStack
    extends StringStack<CharBuffer> {
        protected CharBufferStack() {
        }
    }
}

