/*
 * Decompiled with CFR 0.152.
 */
package xapi.dev.source;

import java.lang.reflect.Modifier;
import xapi.dev.source.ClassBuffer;
import xapi.dev.source.MemberBuffer;
import xapi.dev.source.MethodBuffer;
import xapi.dev.source.PrintBuffer;
import xapi.source.read.JavaLexer;
import xapi.source.read.JavaVisitor;

public class FieldBuffer
extends MemberBuffer<FieldBuffer> {
    private final ClassBuffer cls;
    private final JavaVisitor.TypeData fieldType;
    private final JavaLexer.TypeDef methodType;
    private final String fieldName;
    private final String simpleType;
    private final String methodFragment;
    private PrintBuffer initializer;
    private MethodBuffer get;
    private MethodBuffer set;
    private MethodBuffer add;
    private MethodBuffer remove;
    private MethodBuffer clear;
    private boolean fluent = true;
    private boolean exact;

    public FieldBuffer(ClassBuffer enclosingClass, String type, String name) {
        this(enclosingClass, type, name, "  ");
    }

    public FieldBuffer(ClassBuffer enclosingClass, String type, String name, String indent) {
        super(indent);
        this.cls = enclosingClass;
        this.fieldName = name;
        this.methodFragment = Character.toUpperCase(name.charAt(0)) + (name.length() == 0 ? "" : name.substring(1));
        this.indent = indent + "  ";
        this.simpleType = this.cls.addImport(type);
        this.methodType = JavaLexer.extractType(this.simpleType, 0);
        this.fieldType = this.initGenerator(this.methodType);
    }

    public MethodBuffer addAdder() {
        if (this.add == null) {
            this.add = this.initAdder();
        }
        return this.add;
    }

    public MethodBuffer addClearer() {
        if (this.clear == null) {
            this.clear = this.initClearer();
        }
        return this.clear;
    }

    public MethodBuffer addGetter(int modifiers) {
        if (this.get == null) {
            this.get = this.initGetter();
        }
        this.get.visitModifier(modifiers, this.cls.context);
        return this.get;
    }

    @Override
    public String addImport(Class<?> cls) {
        return this.cls.addImport(cls);
    }

    @Override
    public String addImport(String cls) {
        if (cls.replace(this.cls.getPackage() + ".", "").indexOf(46) == -1) {
            return cls;
        }
        return this.cls.addImport(cls);
    }

    @Override
    public String addImportStatic(Class<?> cls, String name) {
        return this.cls.addImportStatic(cls, name);
    }

    @Override
    public String addImportStatic(String cls) {
        return this.cls.addImportStatic(cls);
    }

    public MethodBuffer addSetter(int modifier) {
        if (this.set == null) {
            this.set = this.initSetter();
        }
        this.set.visitModifier(modifier, this.cls.context);
        return this.set;
    }

    public PrintBuffer getInitializer() {
        if (this.initializer == null) {
            this.initializer = new PrintBuffer();
            this.initializer.indent = this.indent;
            this.initializer.println().indent();
        }
        return this.initializer;
    }

    public String getName() {
        return this.fieldName;
    }

    public String getSimpleType() {
        return this.simpleType;
    }

    public boolean isFluent() {
        return this.fluent;
    }

    public FieldBuffer remover() {
        if (this.remove == null) {
            this.remove = this.initRemover();
        }
        return this;
    }

    public FieldBuffer setExactName(boolean exact) {
        this.exact = exact;
        return this;
    }

    public FieldBuffer setFluent(boolean fluent) {
        this.fluent = fluent;
        return this;
    }

    public FieldBuffer setInitializer(String initializer) {
        this.initializer = new PrintBuffer();
        this.initializer.print(initializer);
        return this;
    }

    @Override
    public String toString() {
        String init;
        String mods;
        if (this.fieldType == JavaVisitor.TypeData.NONE) {
            return super.toString();
        }
        StringBuilder b = new StringBuilder(Character.toString('\n'));
        if (this.javaDoc != null && this.javaDoc.isNotEmpty()) {
            b.append(this.javaDoc.toString());
        }
        b.append(this.origIndent);
        if (this.annotations.size() > 0) {
            for (String anno : this.annotations) {
                b.append('@').append(anno).append('\n' + this.origIndent);
            }
        }
        if ((mods = Modifier.toString(this.modifier)).length() > 0) {
            b.append(mods).append(" ");
        }
        if (this.generics.size() > 0) {
            b.append("<");
            String prefix = "";
            for (String generic : this.generics) {
                b.append(prefix);
                b.append(generic);
                prefix = ", ";
            }
            b.append("> ");
        }
        b.append(this.simpleType).append(" ");
        b.append(this.fieldName);
        String string = init = this.initializer == null ? "" : this.initializer.toString();
        if (init.length() > 0) {
            b.append(" = ").append(init);
            if (!init.trim().endsWith(";")) {
                b.append(";");
            }
        } else {
            b.append(";");
        }
        b.append("\n");
        return b.toString() + super.toString();
    }

    protected String fluentReturnType() {
        return this.fluent ? this.cls.getSimpleName() : "void";
    }

    protected String fluentReturnValue() {
        return this.fluent ? "this" : "";
    }

    protected String getterName() {
        return this.exact ? this.fieldName : (this.fieldType.clsName.equalsIgnoreCase("boolean") ? "is" : "get") + this.methodFragment;
    }

    protected MethodBuffer initAdder() {
        return ((MethodBuffer)this.cls.createMethod("public " + this.fluentReturnType() + " add" + this.methodFragment + "(" + this.simpleType + " " + this.fieldName + ")").println("this." + this.fieldName + " = " + this.fieldName + ";")).returnValue(this.fluentReturnValue());
    }

    protected MethodBuffer initClearer() {
        return this.cls.createMethod("public " + this.simpleType + " get" + this.methodFragment + "()").returnValue(this.fieldName);
    }

    protected JavaVisitor.TypeData initGenerator(JavaVisitor.TypeData originalType) {
        if (originalType.arrayDepth > 0) {
            // empty if block
        }
        return originalType;
    }

    protected MethodBuffer initGetter() {
        return this.cls.createMethod("public " + this.methodType + " " + this.getterName() + "()").returnValue(this.fieldName);
    }

    protected MethodBuffer initRemover() {
        return ((MethodBuffer)this.cls.createMethod("public " + this.fluentReturnType() + " remove" + this.methodFragment + "(" + this.simpleType + " " + this.fieldName + ")").println("this." + this.fieldName + " = null;")).returnValue(this.fluentReturnValue());
    }

    protected MethodBuffer initSetter() {
        MethodBuffer setter = (MethodBuffer)this.cls.createMethod("public " + this.fluentReturnType() + " " + this.setterName() + "(" + this.simpleType + " " + this.fieldName + ")").println("this." + this.fieldName + " = " + this.fieldName + ";");
        if (this.isFluent()) {
            setter.returnValue(this.fluentReturnValue());
        }
        return setter;
    }

    protected String setterName() {
        return this.exact ? this.fieldName : "set" + this.methodFragment;
    }
}

