/*
 * Decompiled with CFR 0.152.
 */
package xapi.dev.source;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import xapi.collect.impl.SimpleStack;
import xapi.dev.source.ClassBuffer;
import xapi.dev.source.MemberBuffer;
import xapi.dev.source.SourceBuilder;
import xapi.source.read.JavaLexer;
import xapi.source.read.JavaModel;
import xapi.source.read.JavaVisitor;

public class MethodBuffer
extends MemberBuffer<MethodBuffer>
implements JavaVisitor.MethodVisitor<SourceBuilder<?>> {
    protected SourceBuilder<?> context;
    private boolean once;
    private boolean useJsni = true;
    private String methodName;
    private final LinkedHashSet<String> parameters;
    private final LinkedHashSet<String> exceptions;
    private JavaVisitor.TypeData returnType;
    private int tryDepth;

    public MethodBuffer(SourceBuilder<?> context) {
        this(context, "  ");
    }

    public MethodBuffer(SourceBuilder<?> context, String indent) {
        super(indent);
        this.context = context;
        this.indent = indent + "  ";
        this.parameters = new LinkedHashSet();
        this.exceptions = new LinkedHashSet();
    }

    @Override
    public String toString() {
        String suffix;
        String prefix;
        StringBuilder b = new StringBuilder(Character.toString('\n'));
        if (this.javaDoc != null && this.javaDoc.isNotEmpty()) {
            b.append(this.javaDoc.toString());
        }
        b.append(this.origIndent);
        if (this.annotations.size() > 0) {
            for (Iterator anno : this.annotations) {
                b.append('@').append((String)((Object)anno)).append('\n').append(this.origIndent);
            }
        }
        b.append(Modifier.toString(this.modifier));
        if ((this.modifier & 0x10000) == 65536) {
            b.append(" default");
        }
        if (this.returnType.simpleName.length() > 0) {
            b.append(" ");
        }
        if (this.generics.size() > 0) {
            b.append("<");
            prefix = "";
            for (String generic : this.generics) {
                b.append(prefix);
                b.append(generic);
                prefix = ", ";
            }
            b.append("> ");
        }
        b.append(this.returnType);
        b.append(" ");
        if (this.methodName.length() > 0) {
            b.append(this.methodName);
        }
        b.append(" (");
        prefix = "";
        for (String parameter : this.parameters) {
            b.append(prefix).append(parameter);
            prefix = ", ";
        }
        b.append(") ");
        if (!this.exceptions.isEmpty()) {
            b.append("\n" + this.indent + "  throws ");
            prefix = "";
            for (String exception : this.exceptions) {
                b.append(prefix).append(exception);
                prefix = ", ";
            }
        }
        if (Modifier.isAbstract(this.modifier)) {
            prefix = ";\n";
            suffix = "";
        } else if (Modifier.isNative(this.modifier)) {
            if (this.useJsni) {
                prefix = "/*-{\n";
                suffix = (this.once ? Character.valueOf('\n') : "") + this.origIndent + "}-*/;\n";
            } else {
                prefix = ";\n";
                suffix = "";
            }
        } else {
            prefix = "{\n";
            suffix = (this.once ? Character.valueOf('\n') : "") + this.origIndent + "}\n";
        }
        return b.toString() + prefix + super.toString() + suffix;
    }

    public MethodBuffer addExceptions(String ... exceptions) {
        this.addTypes(this.exceptions, exceptions);
        return this;
    }

    @Override
    public String addImport(Class<?> cls) {
        return this.context.getImports().addImport(cls);
    }

    @Override
    public String addImport(String cls) {
        String noPkg = cls.replace(this.context.getPackage() + ".", "");
        if (noPkg.indexOf(46) == -1) {
            return noPkg;
        }
        return this.context.getImports().addImport(cls);
    }

    @Override
    public String addImportStatic(Class<?> cls, String name) {
        return this.context.getImports().addStatic(cls, name);
    }

    @Override
    public String addImportStatic(String cls) {
        return this.context.getImports().addStatic(cls);
    }

    public MethodBuffer addParameters(String ... parameters) {
        for (String parameter : parameters) {
            JavaModel.IsParameter param = JavaLexer.lexParam(parameter);
            this.parameters.add(param.toString());
        }
        return this;
    }

    public MethodBuffer addParameter(Class<?> type, String name) {
        String typeName = this.addImport(type);
        this.parameters.add(typeName + " " + name);
        return this;
    }

    public MethodBuffer addParameter(String type, String name) {
        String typeName = this.addImport(type);
        this.parameters.add(typeName + " " + name);
        return this;
    }

    public MethodBuffer addParameters(Map.Entry<String, Class<?>> ... parameters) {
        return this.addParameters(Arrays.asList(parameters));
    }

    public MethodBuffer addParameters(Iterable<Map.Entry<String, Class<?>>> parameters) {
        this.addNamedTypes(this.parameters, parameters);
        return this;
    }

    public MethodBuffer addExceptions(Class<?> ... exceptions) {
        this.addTypes(this.exceptions, exceptions);
        return this;
    }

    public MethodBuffer setExceptions(Class<?> ... exceptions) {
        this.exceptions.clear();
        this.addTypes(this.exceptions, exceptions);
        return this;
    }

    public MethodBuffer setExceptions(String ... exceptions) {
        this.exceptions.clear();
        this.addTypes(this.exceptions, exceptions);
        return this;
    }

    public MethodBuffer setDefinition(String definition) {
        JavaLexer.visitMethodSignature(this, this.context, definition, 0);
        return this;
    }

    public MethodBuffer setName(String name) {
        this.methodName = name;
        return this;
    }

    public MethodBuffer setParameters(String ... parameters) {
        this.parameters.clear();
        return this.addParameters(parameters);
    }

    public MethodBuffer setParameters(Map.Entry<String, Class<?>> ... parameters) {
        this.parameters.clear();
        return this.addParameters(Arrays.asList(parameters));
    }

    public MethodBuffer setParameters(Iterable<Map.Entry<String, Class<?>>> parameters) {
        this.parameters.clear();
        return this.addParameters(parameters);
    }

    public MethodBuffer setReturnType(Class<?> cls) {
        String pkgName = cls.getPackage().getName();
        this.returnType = pkgName.length() == 0 ? new JavaVisitor.TypeData("", cls.getCanonicalName()) : new JavaVisitor.TypeData(pkgName, cls.getCanonicalName().replace(pkgName + ".", ""));
        return this;
    }

    public MethodBuffer setReturnType(String pkgName, String enclosedClassName) {
        this.returnType = new JavaVisitor.TypeData(pkgName, enclosedClassName);
        return this;
    }

    public MethodBuffer setReturnType(String canonicalName) {
        this.returnType = "".equals(canonicalName) ? new JavaVisitor.TypeData("") : JavaLexer.extractType(canonicalName, 0);
        return this;
    }

    public ClassBuffer createLocalClass(String classDef) {
        ClassBuffer cls = new ClassBuffer(this.context, this.indent);
        cls.setDefinition(classDef, classDef.trim().endsWith("{"));
        assert (cls.privacy == 0) : "A local class cannot be " + Modifier.toString(cls.privacy);
        this.addToEnd(cls);
        this.setNotIndent();
        return cls;
    }

    @Override
    protected void onAppend() {
        if (this.once) {
            this.once = false;
            this.onFirstAppend();
        }
        super.onAppend();
    }

    protected void onFirstAppend() {
    }

    public MethodBuffer setUseJsni(boolean useJsni) {
        this.useJsni = useJsni;
        this.modifier |= 0x100;
        return this;
    }

    public final MethodBuffer makeJsni() {
        this.setUseJsni(true).makeNative();
        return this;
    }

    public final MethodBuffer makeNative() {
        if ((this.modifier & 0x400) > 0) {
            this.modifier &= 0xFFFFFBFF;
        }
        this.modifier |= 0x100;
        return this;
    }

    @Override
    public final MethodBuffer makeAbstract() {
        return (MethodBuffer)super.makeAbstract();
    }

    public MethodBuffer returnValue(String name) {
        return (MethodBuffer)this.println((name.matches("\\s*(throw|return)\\s.*") ? "" : "return ") + name + (name.endsWith(";") ? "" : ";"));
    }

    @Override
    public JavaVisitor.ParameterVisitor<SourceBuilder<?>> visitParameter() {
        return new JavaVisitor.ParameterVisitor<SourceBuilder<?>>(){
            int modifier;
            private final SimpleStack<String> annotations = new SimpleStack();

            @Override
            public JavaVisitor.AnnotationMemberVisitor<SourceBuilder<?>> visitAnnotation(String annoName, String annoBody, SourceBuilder<?> receiver) {
                annoName = MethodBuffer.this.addImport(annoName.startsWith("@") ? annoName.substring(1) : annoName);
                this.annotations.add("@" + annoName + (annoBody.length() > 0 ? "(" + annoBody + ")" : ""));
                return null;
            }

            @Override
            public void visitModifier(int modifier, SourceBuilder<?> receiver) {
                this.modifier |= modifier;
            }

            @Override
            public void visitType(JavaVisitor.TypeData type, String name, boolean varargs, SourceBuilder<?> receiver) {
                if (type.pkgName.length() > 0) {
                    receiver.getImports().addImport(type.getImportName());
                }
                StringBuilder b = new StringBuilder();
                for (String anno : this.annotations) {
                    b.append(anno).append(' ');
                }
                String mod = Modifier.toString(this.modifier);
                if (mod.length() > 0) {
                    b.append(mod).append(" ");
                }
                if (varargs) {
                    b.append(type.getSimpleName().replace("[]", "") + " ... " + name);
                } else {
                    b.append(type.getSimpleName() + " " + name);
                }
                MethodBuffer.this.parameters.add(b.toString());
            }
        };
    }

    @Override
    public void visitException(String type, SourceBuilder<?> receiver) {
        this.exceptions.add(type);
    }

    @Override
    public JavaVisitor.AnnotationMemberVisitor<SourceBuilder<?>> visitAnnotation(String annoName, String annoBody, SourceBuilder<?> receiver) {
        this.addAnnotation("@" + annoName + (annoBody.trim().length() > 0 ? "(" + annoBody + ")" : ""));
        return null;
    }

    @Override
    public void visitModifier(int modifier, SourceBuilder<?> receiver) {
        assert (this.validModification(this.modifier, modifier));
        this.setModifier(modifier);
    }

    private boolean validModification(int modifier, int change) {
        if ((change & 0x400) > 0) {
            if ((modifier & 8) > 0) {
                throw new AssertionError((Object)("You cannot make a static method abstract.\n" + this));
            }
            if ((modifier & 0x10) > 0) {
                throw new AssertionError((Object)("You cannot make a final method abstract.\n" + this));
            }
        }
        if ((modifier & 0x400) > 0) {
            if ((change & 8) > 0) {
                throw new AssertionError((Object)("You cannot make an abstract method static.\n" + this));
            }
            if ((change & 0x10) > 0) {
                throw new AssertionError((Object)("You cannot make an abstract method final.\n" + this));
            }
        }
        return true;
    }

    @Override
    public void visitGeneric(String generic, SourceBuilder<?> receiver) {
        if ((generic = generic.trim()).charAt(0) == '<') {
            generic = generic.substring(1, generic.length() - 1);
        }
        for (String importable : JavaLexer.findImportsInGeneric(generic)) {
            String imported = receiver.getImports().addImport(importable);
            if (importable.length() == imported.length()) continue;
            int len = -1;
            while (len != generic.length()) {
                len = generic.length();
                generic = generic.replace(importable, imported);
            }
        }
        this.generics.add(generic);
    }

    @Override
    public void visitJavadoc(String javadoc, SourceBuilder<?> receiver) {
    }

    @Override
    public void visitReturnType(JavaVisitor.TypeData returnType, SourceBuilder<?> receiver) {
        this.returnType = returnType;
        if (returnType.pkgName.length() > 0) {
            receiver.getImports().addImport(returnType.getImportName());
        }
    }

    @Override
    public void visitName(String name, SourceBuilder<?> receiver) {
        this.methodName = name;
    }

    public MethodBuffer startTry() {
        ++this.tryDepth;
        this.println("try {");
        this.indent();
        return this;
    }

    public MethodBuffer startTry(String withResources) {
        ++this.tryDepth;
        this.println("try (" + withResources + ") {");
        this.indent();
        return this;
    }

    public MethodBuffer startCatch(String exceptionType, String exceptionName) {
        this.outdent();
        this.println("} catch (" + exceptionType + " " + exceptionName + ") {");
        this.indent();
        return this;
    }

    public String startCatch(String exceptionType) {
        String name;
        this.outdent();
        int ind = exceptionType.lastIndexOf(32);
        if (ind == -1) {
            name = "e" + this.tryDepth;
            exceptionType = exceptionType + " " + name;
        } else {
            name = exceptionType.substring(ind + 1);
        }
        this.println("} catch (" + exceptionType + ") {");
        this.indent();
        return name;
    }

    public MethodBuffer startFinally() {
        this.outdent();
        this.println("} finally {");
        this.indent();
        return this;
    }

    public MethodBuffer endTry() {
        this.outdent();
        this.println("}");
        --this.tryDepth;
        return this;
    }
}

