/*
 * Decompiled with CFR 0.152.
 */
package xapi.dev.source;

import xapi.dev.source.CharBuffer;

public class PrintBuffer
extends CharBuffer {
    static final char NEW_LINE = '\n';
    static final String INDENT = "  ";
    protected boolean indented = false;

    protected static String join(String sep, String[] args) {
        if (args.length == 0) {
            return "";
        }
        StringBuilder b = new StringBuilder(args[0]);
        int m = args.length;
        for (int i = 1; i < m; ++i) {
            b.append(sep).append(args[i]);
        }
        return b.toString();
    }

    public PrintBuffer() {
        super(new StringBuilder());
    }

    public PrintBuffer(int indent) {
        super(new StringBuilder());
        while (indent-- > 0) {
            this.indent();
        }
    }

    public PrintBuffer(PrintBuffer preamble) {
        super(preamble);
    }

    public PrintBuffer(StringBuilder target) {
        super(target);
    }

    public PrintBuffer print(String str) {
        this.printIndent();
        this.append(str);
        return this;
    }

    public PrintBuffer append(CharSequence s) {
        this.onAppend();
        this.target.append(s);
        return this;
    }

    public PrintBuffer append(CharSequence s, int start, int end) {
        this.onAppend();
        this.target.append(s, start, end);
        return this;
    }

    public PrintBuffer append(char[] str) {
        this.onAppend();
        this.target.append(str);
        return this;
    }

    public PrintBuffer append(char[] str, int offset, int len) {
        this.onAppend();
        this.target.append(str, offset, len);
        return this;
    }

    public PrintBuffer append(boolean b) {
        this.onAppend();
        this.target.append(b);
        return this;
    }

    public PrintBuffer append(char c) {
        this.onAppend();
        this.target.append(c);
        return this;
    }

    public PrintBuffer append(int i) {
        this.onAppend();
        this.target.append(i);
        return this;
    }

    public PrintBuffer append(long lng) {
        this.onAppend();
        this.target.append(lng);
        return this;
    }

    public PrintBuffer append(float f) {
        this.onAppend();
        this.target.append(f);
        return this;
    }

    public PrintBuffer append(double d) {
        this.onAppend();
        this.target.append(d);
        return this;
    }

    public PrintBuffer indent() {
        this.indent = this.indent + INDENT;
        return this;
    }

    private void printIndent() {
        if (!this.indented) {
            this.target.append(this.indent);
            this.indented = true;
        }
    }

    public PrintBuffer indentln(Object obj) {
        this.printIndent();
        this.onAppend();
        this.target.append(INDENT);
        this.target.append(obj);
        this.println();
        return this;
    }

    public PrintBuffer indentln(String str) {
        this.printIndent();
        this.onAppend();
        this.target.append(INDENT);
        this.append(str);
        this.println();
        return this;
    }

    public PrintBuffer indentln(CharSequence s) {
        this.printIndent();
        this.onAppend();
        this.target.append(INDENT);
        this.target.append(s);
        this.println();
        return this;
    }

    public PrintBuffer indentln(char[] str) {
        this.printIndent();
        this.onAppend();
        this.target.append(INDENT);
        this.target.append(str);
        this.println();
        return this;
    }

    public PrintBuffer outdent() {
        int end = Math.max(0, this.indent.length() - INDENT.length());
        this.indent = end > 0 ? this.indent.substring(0, end) : "";
        return this;
    }

    public PrintBuffer println() {
        this.onAppend();
        this.target.append('\n');
        this.indented = false;
        return this;
    }

    public PrintBuffer println(Object obj) {
        this.printIndent();
        this.onAppend();
        this.target.append(obj);
        this.println();
        return this;
    }

    public PrintBuffer println(String str) {
        this.printIndent();
        this.onAppend();
        this.append(str);
        this.println();
        return this;
    }

    public PrintBuffer println(CharSequence s) {
        this.printIndent();
        this.onAppend();
        this.target.append(s);
        this.println();
        return this;
    }

    public PrintBuffer println(char[] str) {
        this.printIndent();
        this.onAppend();
        this.target.append(str);
        this.println();
        return this;
    }

    public PrintBuffer printBefore(String prefix) {
        PrintBuffer buffer = new PrintBuffer(new StringBuilder(prefix));
        this.addToBeginning(buffer);
        return buffer;
    }

    protected String header() {
        return "";
    }

    protected String footer() {
        return "";
    }

    protected void setNotIndent() {
        this.indented = false;
    }

    public PrintBuffer clearIndent() {
        this.indent = "";
        return this;
    }

    @Override
    public String toString() {
        StringBuilder body = new StringBuilder(this.header());
        body.append(this.head);
        body.append(this.target.toString());
        return body + this.footer();
    }

    public boolean isEmpty() {
        return this.target.length() == 0 && this.head.next == null;
    }

    public boolean isNotEmpty() {
        return this.target.length() > 0 || this.head.next != null;
    }
}

