/*
 * Decompiled with CFR 0.152.
 */
package xapi.source.impl;

import xapi.source.api.CharIterator;
import xapi.source.api.Lexer;
import xapi.source.impl.LexerDefault;

public class LexerForWords
extends LexerDefault {
    @Override
    protected Lexer consume(char c, CharIterator str) {
        switch (c) {
            case '\r': {
                if (str.hasNext() && str.peek() == '\n') {
                    c = str.next();
                }
            }
            case '\t': 
            case '\n': 
            case ' ': {
                return this.onWhitespace(c, str);
            }
        }
        return this.onWordStart(c, str);
    }

    protected boolean isWhitespace(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    protected Lexer onWordStart(char c, CharIterator str) {
        return this.onWord(this.extractWord(c, str), str);
    }

    protected String extractWord(char c, CharIterator str) {
        StringBuilder b = new StringBuilder().append(c);
        while (str.hasNext()) {
            if (this.isWhitespace(str.peek())) {
                return b.toString();
            }
            b.append(str.next());
        }
        return b.toString();
    }

    protected Lexer onWord(String word, CharIterator str) {
        if (str.hasNext()) {
            return this.consume(str);
        }
        return this;
    }

    protected Lexer onWhitespace(char c, CharIterator str) {
        return super.consume(c, str);
    }
}

