/*
 * Decompiled with CFR 0.152.
 */
package nl.crashdata.chartjs.data.simple.builder;

import java.io.Serializable;
import nl.crashdata.chartjs.data.ChartJsAxisPosition;
import nl.crashdata.chartjs.data.ChartJsCartesianAxisType;
import nl.crashdata.chartjs.data.simple.AbstractSimpleChartJsTickConfig;
import nl.crashdata.chartjs.data.simple.SimpleChartJsAxisConfig;
import nl.crashdata.chartjs.data.simple.builder.AbstractSimpleChartJsTickConfigBuilder;
import nl.crashdata.chartjs.data.simple.builder.SimpleChartJsBuilder;
import nl.crashdata.chartjs.data.simple.builder.SimpleChartJsScaleLabelConfigBuilder;

public abstract class AbstractSimpleChartJsAxisConfigBuilder<T extends Serializable>
implements SimpleChartJsBuilder<SimpleChartJsAxisConfig<T>> {
    private ChartJsCartesianAxisType type;
    private Boolean display;
    private ChartJsAxisPosition position;
    private SimpleChartJsScaleLabelConfigBuilder labelConfigBuilder = new SimpleChartJsScaleLabelConfigBuilder();

    protected AbstractSimpleChartJsAxisConfigBuilder(ChartJsCartesianAxisType type) {
        this.type = type;
    }

    public AbstractSimpleChartJsAxisConfigBuilder<T> withDisplay(Boolean display) {
        this.display = display;
        return this;
    }

    public AbstractSimpleChartJsAxisConfigBuilder<T> withPosition(ChartJsAxisPosition position) {
        this.position = position;
        return this;
    }

    public SimpleChartJsScaleLabelConfigBuilder labelConfig() {
        return this.labelConfigBuilder;
    }

    public abstract AbstractSimpleChartJsTickConfigBuilder<T, ? extends AbstractSimpleChartJsTickConfig<T>> tickConfig();

    @Override
    public boolean isValid() {
        return this.position != null && this.type != null && this.labelConfigBuilder.isValid() && this.tickConfig().isValid();
    }

    @Override
    public SimpleChartJsAxisConfig<T> build() throws IllegalStateException {
        if (!this.isValid()) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " is not ready to build!");
        }
        SimpleChartJsAxisConfig ret = new SimpleChartJsAxisConfig();
        ret.setDisplay(this.display);
        ret.setPosition(this.position);
        ret.setType(this.type);
        ret.setLabelConfig(this.labelConfigBuilder.build());
        ret.setTickConfig(this.tickConfig().build());
        return ret;
    }
}

